/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_GrantRevoke {
    public static void doAuthorizations(Connection conn, boolean at10_6) throws SQLException {
        ResultSet rs;
        Statement stmt = conn.createStatement();
        if (at10_6) {
            rs = stmt.executeQuery("SELECT P.GRANTEE, S.SCHEMANAME, A.ALIAS, P.PERMISSION, P.OBJECTTYPE FROM SYS.SYSPERMS P, SYS.SYSALIASES A, SYS.SYSSCHEMAS S WHERE A.SCHEMAID = S.SCHEMAID AND P.OBJECTID = A.ALIASID AND A.ALIASTYPE='A'");
            DB_GrantRevoke.generateUDTPrivs(rs);
            rs = stmt.executeQuery("SELECT P.GRANTEE, S.SCHEMANAME, SEQ.SEQUENCENAME, P.PERMISSION, P.OBJECTTYPE FROM SYS.SYSPERMS P, SYS.SYSSEQUENCES SEQ, SYS.SYSSCHEMAS S WHERE SEQ.SCHEMAID = S.SCHEMAID AND P.OBJECTID = SEQ.SEQUENCEID");
            DB_GrantRevoke.generateSequencePrivs(rs);
            rs = stmt.executeQuery("SELECT P.GRANTEE, S.SCHEMANAME, A.ALIAS, P.PERMISSION, P.OBJECTTYPE FROM SYS.SYSPERMS P, SYS.SYSALIASES A, SYS.SYSSCHEMAS S WHERE A.SCHEMAID = S.SCHEMAID AND P.OBJECTID = A.ALIASID AND A.ALIASTYPE='G'");
            DB_GrantRevoke.generateAggregatePrivs(rs);
        }
        rs = stmt.executeQuery("SELECT GRANTEE, SCHEMANAME, TABLENAME, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV FROM SYS.SYSTABLEPERMS P, SYS.SYSTABLES T, SYS.SYSSCHEMAS S WHERE T.SCHEMAID = S.SCHEMAID AND T.TABLEID = P.TABLEID");
        DB_GrantRevoke.generateTablePrivs(rs);
        rs = stmt.executeQuery("SELECT GRANTEE, SCHEMANAME, TABLENAME, TYPE, COLUMNS FROM SYS.SYSCOLPERMS P, SYS.SYSTABLES T, SYS.SYSSCHEMAS S WHERE T.SCHEMAID = S.SCHEMAID AND T.TABLEID = P.TABLEID");
        DB_GrantRevoke.generateColumnPrivs(rs, conn);
        rs = stmt.executeQuery("SELECT GRANTEE, SCHEMANAME, ALIAS, ALIASTYPE FROM SYS.SYSROUTINEPERMS P, SYS.SYSALIASES A, SYS.SYSSCHEMAS S WHERE A.SCHEMAID = S.SCHEMAID AND P.ALIASID = A.ALIASID");
        DB_GrantRevoke.generateRoutinePrivs(rs);
        rs.close();
        stmt.close();
    }

    private static void generateTablePrivs(ResultSet rs) throws SQLException {
        boolean firstTime = true;
        while (rs.next()) {
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_TablePrivHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String authName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(1)));
            String schemaName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(2)));
            String tableName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(3)));
            String fullName = schemaName + "." + tableName;
            if (dblook.isIgnorableSchema(schemaName)) continue;
            Logs.writeToNewDDL(DB_GrantRevoke.tablePrivStatement(rs, fullName, authName));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
    }

    private static String separatorStr(boolean addSeparator) {
        return addSeparator ? ", " : "";
    }

    private static String tablePrivStatement(ResultSet rs, String fullName, String authName) throws SQLException {
        boolean addSeparator = false;
        StringBuffer grantStmt = new StringBuffer("GRANT ");
        if (rs.getString(4).toUpperCase().equals("Y")) {
            grantStmt.append("SELECT");
            addSeparator = true;
        }
        if (rs.getString(5).toUpperCase().equals("Y")) {
            grantStmt.append(DB_GrantRevoke.separatorStr(addSeparator) + "DELETE");
            addSeparator = true;
        }
        if (rs.getString(6).toUpperCase().equals("Y")) {
            grantStmt.append(DB_GrantRevoke.separatorStr(addSeparator) + "INSERT");
            addSeparator = true;
        }
        if (rs.getString(7).toUpperCase().equals("Y")) {
            grantStmt.append(DB_GrantRevoke.separatorStr(addSeparator) + "UPDATE");
            addSeparator = true;
        }
        if (rs.getString(8).toUpperCase().equals("Y")) {
            grantStmt.append(DB_GrantRevoke.separatorStr(addSeparator) + "REFERENCES");
            addSeparator = true;
        }
        if (rs.getString(9).toUpperCase().equals("Y")) {
            grantStmt.append(DB_GrantRevoke.separatorStr(addSeparator) + "TRIGGER");
            addSeparator = true;
        }
        grantStmt.append(" ON " + fullName + " TO " + authName);
        return grantStmt.toString();
    }

    private static void generateColumnPrivs(ResultSet rs, Connection conn) throws SQLException {
        PreparedStatement columnStmt = conn.prepareStatement("SELECT COLUMNNUMBER, COLUMNNAME FROM SYS.SYSCOLUMNS C, SYS.SYSTABLES T, SYS.SYSSCHEMAS S WHERE T.TABLEID = C.REFERENCEID and S.SCHEMAID = T.SCHEMAID AND S.SCHEMANAME = ? AND T.TABLENAME = ? ORDER BY COLUMNNUMBER");
        boolean firstTime = true;
        while (rs.next()) {
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_ColumnPrivHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String authName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(1)));
            String schemaName = rs.getString(2);
            String tableName = rs.getString(3);
            String schemaNameQuoted = dblook.addQuotes(dblook.expandDoubleQuotes(schemaName));
            if (dblook.isIgnorableSchema(schemaNameQuoted)) continue;
            columnStmt.setString(1, schemaName);
            columnStmt.setString(2, tableName);
            ResultSet rsCols = columnStmt.executeQuery();
            String fullName = schemaNameQuoted + "." + dblook.addQuotes(dblook.expandDoubleQuotes(tableName));
            Logs.writeToNewDDL(DB_GrantRevoke.columnPrivStatement(rs, fullName, authName, rsCols));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
            rsCols.close();
        }
        columnStmt.close();
    }

    private static String privTypeToString(String privType) {
        if (privType.equals("S")) {
            return "SELECT";
        }
        if (privType.equals("R")) {
            return "REFERENCES";
        }
        if (privType.equals("U")) {
            return "UPDATE";
        }
        return "";
    }

    private static String mapColumnsToNames(String columns, ResultSet rsCols) throws SQLException {
        StringBuffer colNames = new StringBuffer();
        rsCols.next();
        int curColumn = 1;
        boolean addSeparator = false;
        StringTokenizer st = new StringTokenizer(columns, " ,{}");
        while (st.hasMoreTokens()) {
            int colNum = Integer.parseInt(st.nextToken());
            while (colNum + 1 > curColumn) {
                rsCols.next();
                curColumn = rsCols.getInt(1);
            }
            colNames.append(DB_GrantRevoke.separatorStr(addSeparator));
            addSeparator = true;
            String colName = dblook.addQuotes(dblook.expandDoubleQuotes(rsCols.getString(2)));
            colNames.append(colName);
        }
        return colNames.toString();
    }

    private static String columnPrivStatement(ResultSet rs, String fullName, String authName, ResultSet rsCols) throws SQLException {
        StringBuffer grantStmt = new StringBuffer("GRANT ");
        String privType = rs.getString(4).toUpperCase();
        String columns = rs.getString(5);
        grantStmt.append(DB_GrantRevoke.privTypeToString(privType));
        grantStmt.append("(");
        grantStmt.append(DB_GrantRevoke.mapColumnsToNames(columns, rsCols));
        grantStmt.append(") ON ");
        grantStmt.append(fullName);
        grantStmt.append(" TO ");
        grantStmt.append(authName);
        return grantStmt.toString();
    }

    public static void generateUDTPrivs(ResultSet rs) throws SQLException {
        boolean firstTime = true;
        while (rs.next()) {
            String authName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(1)));
            String schemaName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(2)));
            String aliasName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(3)));
            String fullName = schemaName + "." + aliasName;
            String permission = rs.getString(4);
            String objectType = rs.getString(5);
            if (dblook.isIgnorableSchema(schemaName)) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_UDTPrivHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            Logs.writeToNewDDL(DB_GrantRevoke.genericPrivStatement(fullName, authName, permission, objectType));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
    }

    public static void generateSequencePrivs(ResultSet rs) throws SQLException {
        boolean firstTime = true;
        while (rs.next()) {
            String authName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(1)));
            String schemaName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(2)));
            String sequenceName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(3)));
            String fullName = schemaName + "." + sequenceName;
            String permission = rs.getString(4);
            String objectType = rs.getString(5);
            if (dblook.isIgnorableSchema(schemaName)) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_SequencePrivHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            Logs.writeToNewDDL(DB_GrantRevoke.genericPrivStatement(fullName, authName, permission, objectType));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
    }

    public static void generateAggregatePrivs(ResultSet rs) throws SQLException {
        boolean firstTime = true;
        while (rs.next()) {
            String authName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(1)));
            String schemaName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(2)));
            String aliasName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(3)));
            String fullName = schemaName + "." + aliasName;
            String permission = rs.getString(4);
            String objectType = rs.getString(5);
            if (dblook.isIgnorableSchema(schemaName)) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_AggregatePrivHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            Logs.writeToNewDDL(DB_GrantRevoke.genericPrivStatement(fullName, authName, permission, objectType));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
    }

    private static String genericPrivStatement(String fullName, String authName, String permission, String objectType) throws SQLException {
        boolean addSeparator = false;
        StringBuffer grantStmt = new StringBuffer("GRANT " + permission + " ON " + objectType + " ");
        grantStmt.append(fullName);
        grantStmt.append(" TO ");
        grantStmt.append(authName);
        return grantStmt.toString();
    }

    public static void generateRoutinePrivs(ResultSet rs) throws SQLException {
        boolean firstTime = true;
        while (rs.next()) {
            String authName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(1)));
            String schemaName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(2)));
            String aliasName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(3)));
            String fullName = schemaName + "." + aliasName;
            String aliasType = rs.getString(4);
            if (dblook.isIgnorableSchema(schemaName) || schemaName.equals("\"SYSCS_UTIL\"")) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_RoutinePrivHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            Logs.writeToNewDDL(DB_GrantRevoke.routinePrivStatement(fullName, authName, aliasType));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
    }

    private static String routinePrivStatement(String fullName, String authName, String aliasType) throws SQLException {
        boolean addSeparator = false;
        StringBuffer grantStmt = new StringBuffer("GRANT EXECUTE ON ");
        grantStmt.append(aliasType.equals("P") ? "PROCEDURE " : "FUNCTION ");
        grantStmt.append(fullName);
        grantStmt.append(" TO ");
        grantStmt.append(authName);
        return grantStmt.toString();
    }
}

