/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.admin;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.cdo.server.admin.CDORepositoryConfigurationManager;
import org.eclipse.emf.cdo.server.internal.admin.InternalCDORepositoryConfigurationManager;
import org.eclipse.emf.cdo.server.internal.admin.bundle.OM;
import org.eclipse.emf.cdo.spi.server.IAppExtension5;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.RepositoryFactory;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RepositoryConfigurationManagerExtension
implements IAppExtension5 {
    private static final String DEFAULT_CATALOG_PATH = "/catalog";
    private CDORepositoryConfigurationManager repositoryConfigurationManager;

    public String getName() {
        return "Repository configuration manager";
    }

    public boolean startBeforeRepositories() {
        return false;
    }

    public void start(File configFile) throws Exception {
        IPluginContainer container = IPluginContainer.INSTANCE;
        Document document = this.getDocument(configFile);
        NodeList repositoryConfigs = document.getElementsByTagName("repository");
        int i = 0;
        while (i < repositoryConfigs.getLength()) {
            Element repositoryConfig = (Element)repositoryConfigs.item(i);
            CDORepositoryConfigurationManager repositoryConfigurationManager = this.configureAdminRepository((IManagedContainer)container, repositoryConfig);
            if (repositoryConfigurationManager != null) {
                this.repositoryConfigurationManager = repositoryConfigurationManager;
                break;
            }
            ++i;
        }
    }

    public void stop() throws Exception {
        LifecycleUtil.deactivate((Object)this.repositoryConfigurationManager);
    }

    protected Document getDocument(File configFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(configFile);
    }

    protected CDORepositoryConfigurationManager configureAdminRepository(IManagedContainer container, Element repositoryConfig) {
        String name = repositoryConfig.getAttribute("name");
        InternalRepository repository = (InternalRepository)RepositoryFactory.get((IManagedContainer)container, (String)name);
        if (repository == null) {
            OM.LOG.warn("Repository not registered with container: " + name);
            return null;
        }
        NodeList adminRepositories = repositoryConfig.getElementsByTagName("adminRepository");
        if (adminRepositories.getLength() > 1) {
            OM.LOG.warn("A maximum of one administration catalog can be configured in repository " + repository);
            return null;
        }
        if (adminRepositories.getLength() == 1) {
            Element adminRepositoryElement = (Element)adminRepositories.item(0);
            String type = adminRepositoryElement.getAttribute("configurationManager");
            if (type == null || type.length() == 0) {
                OM.LOG.warn("Repository configuration manager type not specified for repository " + repository);
                return null;
            }
            String description = adminRepositoryElement.getAttribute("description");
            if (StringUtil.isEmpty((String)description)) {
                description = adminRepositoryElement.getAttribute("catalogPath");
            }
            if (StringUtil.isEmpty((String)description)) {
                description = DEFAULT_CATALOG_PATH;
            }
            InternalCDORepositoryConfigurationManager repoManager = (InternalCDORepositoryConfigurationManager)container.getElement("org.eclipse.emf.cdo.server.admin.repositoryConfigurationManagers", type, description);
            repoManager.setAdminRepository(repository);
            OM.LOG.info("Admin repository: " + repository.getName());
            return repoManager;
        }
        return null;
    }
}

