/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.view;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public interface CDORegistrationHandler {
    public void objectRegistered(CDOView var1, CDOObject var2);

    public void objectDeregistered(CDOView var1, CDOObject var2);

    public void objectCollected(CDOView var1, CDOID var2);

    public static class Default
    implements CDORegistrationHandler {
        private final IListener deactivateListener = new LifecycleEventAdapter(){

            protected void onDeactivated(ILifecycle lifecycle) {
                this.dispose();
            }
        };
        private CDOView view;

        public Default(final CDOView view) {
            view.syncExec(new Runnable(){

                @Override
                public void run() {
                    this.doInitialize(view);
                }
            });
            this.view = view;
        }

        public final CDOView getView() {
            return this.view;
        }

        public final boolean isDisposed() {
            return this.view == null;
        }

        public synchronized void dispose() {
            if (this.view != null) {
                final CDOView finalView = this.view;
                this.view = null;
                finalView.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        this.doDispose(finalView);
                    }
                });
            }
        }

        @Override
        public void objectRegistered(CDOView view, CDOObject object) {
        }

        @Override
        public void objectDeregistered(CDOView view, CDOObject object) {
        }

        @Override
        public void objectCollected(CDOView view, CDOID id) {
        }

        protected void doInitialize(CDOView view) {
            if (LifecycleUtil.isActive((Object)view)) {
                for (InternalCDOObject object : ((InternalCDOView)view).getObjects().values()) {
                    this.objectRegistered(view, object);
                }
            }
            view.addRegistrationHandler(this);
            view.addListener(this.deactivateListener);
        }

        protected void doDispose(CDOView view) {
            view.removeListener(this.deactivateListener);
            view.removeRegistrationHandler(this);
            if (LifecycleUtil.isActive((Object)view)) {
                for (InternalCDOObject object : ((InternalCDOView)view).getObjects().values()) {
                    this.objectDeregistered(view, object);
                }
            }
        }
    }
}

