/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.migrator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.internal.messages.Messages;
import org.eclipse.emf.codegen.ecore.genmodel.GenDelegationKind;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public abstract class CDOMigratorUtil {
    public static final String ROOT_EXTENDS_CLASS = "org.eclipse.emf.internal.cdo.CDOObjectImpl";
    public static final String ROOT_EXTENDS_INTERFACE = "org.eclipse.emf.cdo.CDOObject";
    public static final String PLUGIN_VARIABLE = "CDO=org.eclipse.emf.cdo";
    public static final String EDIT_PLUGIN_VARIABLE = "CDO_EDIT=org.eclipse.emf.cdo.edit";
    public static final String PROVIDER_ROOT_EXTENDS_CLASS = "org.eclipse.emf.cdo.edit.CDOItemProviderAdapter";

    private CDOMigratorUtil() {
    }

    public static List<GenModel> getGenModels(List<String> paths) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
        XMIResourceFactoryImpl factory = new XMIResourceFactoryImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", factory);
        resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().put("*", factory);
        resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().put("*", factory);
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String path : paths) {
            URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
            try {
                resourceSet.getResource(uri, true);
                uris.add(uri);
            }
            catch (Exception ex) {
                System.err.println("Ignoring " + uri + " (" + ex.getMessage() + ")");
            }
        }
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        ArrayList<GenModel> genModels = new ArrayList<GenModel>();
        for (URI uri : uris) {
            EObject object;
            Resource resource = resourceSet.getResource(uri, true);
            EList contents = resource.getContents();
            if (!contents.isEmpty() && (object = (EObject)contents.get(0)) instanceof GenModel) {
                genModels.add((GenModel)object);
                continue;
            }
            System.err.println("Ignoring " + uri + " (Resource does not contain a GenModel)");
        }
        return genModels;
    }

    public static GenModel getGenModel(String path) {
        List<GenModel> genModels = CDOMigratorUtil.getGenModels(Arrays.asList(path));
        return genModels.isEmpty() ? null : genModels.get(0);
    }

    public static String adjustGenModel(GenModel genModel) {
        return CDOMigratorUtil.adjustGenModel(genModel, GenDelegationKind.REFLECTIVE_LITERAL);
    }

    public static String adjustGenModel(GenModel genModel, GenDelegationKind featureDelegation) {
        IWorkspaceRoot root;
        IFolder modelFolder;
        IProject modelProject;
        EList editPluginVariables;
        EList pluginVariables;
        StringBuilder builder = new StringBuilder();
        if (genModel.getFeatureDelegation() != featureDelegation) {
            genModel.setFeatureDelegation(featureDelegation);
            builder.append(Messages.getString("CDOMigratorUtil.4"));
            builder.append(" ");
            builder.append(featureDelegation);
            builder.append("\n");
        }
        if (genModel.getBooleanFlagsField() != null) {
            genModel.setBooleanFlagsField(null);
            builder.append(Messages.getString("CDOMigratorUtil.1"));
            builder.append(" null\n");
        }
        if (genModel.getBooleanFlagsReservedBits() != -1) {
            genModel.setBooleanFlagsReservedBits(-1);
            builder.append(Messages.getString("CDOMigratorUtil.2"));
            builder.append(" -1\n");
        }
        if (genModel.isPackedEnums()) {
            genModel.setPackedEnums(false);
            builder.append(Messages.getString("CDOMigratorUtil.3"));
            builder.append(" false\n");
        }
        if (!ROOT_EXTENDS_CLASS.equals(genModel.getRootExtendsClass())) {
            genModel.setRootExtendsClass(ROOT_EXTENDS_CLASS);
            builder.append(Messages.getString("CDOMigratorUtil.6"));
            builder.append(" ");
            builder.append(ROOT_EXTENDS_CLASS);
            builder.append("\n");
        }
        if (!ROOT_EXTENDS_INTERFACE.equals(genModel.getRootExtendsInterface())) {
            genModel.setRootExtendsInterface(ROOT_EXTENDS_INTERFACE);
            builder.append(Messages.getString("CDOMigratorUtil.8"));
            builder.append(" ");
            builder.append(ROOT_EXTENDS_INTERFACE);
            builder.append("\n");
        }
        if (!(pluginVariables = genModel.getModelPluginVariables()).contains((Object)PLUGIN_VARIABLE)) {
            pluginVariables.add((Object)PLUGIN_VARIABLE);
            builder.append(Messages.getString("CDOMigratorUtil.10"));
            builder.append(" ");
            builder.append(PLUGIN_VARIABLE);
            builder.append("\n");
        }
        if (!(editPluginVariables = genModel.getEditPluginVariables()).contains((Object)EDIT_PLUGIN_VARIABLE)) {
            editPluginVariables.add((Object)EDIT_PLUGIN_VARIABLE);
            builder.append(Messages.getString("CDOMigratorUtil.11"));
            builder.append(" ");
            builder.append(EDIT_PLUGIN_VARIABLE);
            builder.append("\n");
        }
        if (!PROVIDER_ROOT_EXTENDS_CLASS.equals(genModel.getProviderRootExtendsClass())) {
            genModel.setProviderRootExtendsClass(PROVIDER_ROOT_EXTENDS_CLASS);
            builder.append(Messages.getString("CDOMigratorUtil.9"));
            builder.append(" ");
            builder.append(PROVIDER_ROOT_EXTENDS_CLASS);
            builder.append("\n");
        }
        if (!(modelProject = (modelFolder = (root = ResourcesPlugin.getWorkspace().getRoot()).getFolder((IPath)new Path(genModel.getModelDirectory()))).getProject()).exists()) {
            try {
                modelProject.create((IProgressMonitor)new NullProgressMonitor());
                builder.append(String.valueOf(Messages.getString("CDOMigratorUtil.12")) + "\n");
            }
            catch (CoreException ex) {
                throw new WrappedException((Exception)((Object)ex));
            }
        }
        if (!modelProject.isOpen()) {
            try {
                modelProject.open((IProgressMonitor)new NullProgressMonitor());
                builder.append(String.valueOf(Messages.getString("CDOMigratorUtil.13")) + "\n");
            }
            catch (CoreException ex) {
                throw new WrappedException((Exception)((Object)ex));
            }
        }
        return builder.length() == 0 ? null : builder.toString();
    }
}

