/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.lock;

import java.util.Objects;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.net4j.util.ObjectUtil;

public class CDOLockOwnerImpl
implements CDOLockOwner {
    private final int sessionID;
    private final int viewID;
    private final String durableLockingID;

    public CDOLockOwnerImpl(int sessionID, int viewID, String durableLockingID) {
        this.sessionID = sessionID;
        this.viewID = viewID;
        this.durableLockingID = durableLockingID;
    }

    @Override
    public int getSessionID() {
        return this.sessionID;
    }

    @Override
    public int getViewID() {
        return this.viewID;
    }

    @Override
    public String getDurableLockingID() {
        return this.durableLockingID;
    }

    @Override
    public boolean isDurableView() {
        return this.sessionID == 0;
    }

    public int hashCode() {
        if (this.isDurableView()) {
            return ObjectUtil.hashCode((Object)this.durableLockingID);
        }
        return ObjectUtil.hashCode((int[])new int[]{this.sessionID, this.viewID});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CDOLockOwner) {
            CDOLockOwner that = (CDOLockOwner)obj;
            if (this.isDurableView()) {
                return that.isDurableView() && Objects.equals(this.durableLockingID, that.getDurableLockingID());
            }
            return !that.isDurableView() && this.sessionID == that.getSessionID() && this.viewID == that.getViewID();
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CDOLockOwner[");
        if (this.isDurableView()) {
            builder.append("durable:");
            builder.append(this.durableLockingID);
        } else {
            builder.append(this.sessionID);
            builder.append(':');
            builder.append(this.viewID);
        }
        builder.append(']');
        return builder.toString();
    }
}

