/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.id;

import java.io.IOException;
import java.io.ObjectStreamException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDString;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.common.id.CDOIDExternalImpl;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.net4j.util.ref.Interner;

public final class CDOIDTempObjectExternalImpl
extends AbstractCDOID
implements CDOIDExternal,
CDOIDTemp,
CDOIDString {
    private static final long serialVersionUID = 1L;
    private static final StringInterner INTERNER = new StringInterner();
    private final String uri;

    private CDOIDTempObjectExternalImpl(String uri) {
        CDOIDExternalImpl.checkURI(uri);
        this.uri = uri;
    }

    private CDOIDTempObjectExternalImpl() {
        this.uri = null;
    }

    @Override
    public void write(CDODataOutput out) throws IOException {
        out.writeString(this.uri);
    }

    @Override
    public String toURIFragment() {
        return this.uri;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String getStringValue() {
        return this.uri;
    }

    @Override
    public CDOID.Type getType() {
        return CDOID.Type.EXTERNAL_TEMP_OBJECT;
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isTemporary() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.uri.hashCode();
    }

    @Override
    public String toString() {
        return "oid:" + this.uri;
    }

    @Override
    protected int doCompareTo(CDOID o) throws ClassCastException {
        return this.uri.compareTo(((CDOIDTempObjectExternalImpl)o).uri);
    }

    private Object readResolve() throws ObjectStreamException {
        return CDOIDTempObjectExternalImpl.create(this.uri);
    }

    private static int getHashCode(String uri) {
        return uri.hashCode();
    }

    public static CDOIDTempObjectExternalImpl create(String uri) {
        return INTERNER.intern(uri);
    }

    public static CDOIDTempObjectExternalImpl create(CDODataInput in) throws IOException {
        String uri = in.readString();
        return CDOIDTempObjectExternalImpl.create(uri);
    }

    /* synthetic */ CDOIDTempObjectExternalImpl(String string, CDOIDTempObjectExternalImpl cDOIDTempObjectExternalImpl) {
        this(string);
    }

    private static final class StringInterner
    extends Interner<CDOIDTempObjectExternalImpl> {
        private StringInterner() {
        }

        public synchronized CDOIDTempObjectExternalImpl intern(String uri) {
            int hashCode = CDOIDTempObjectExternalImpl.getHashCode(uri);
            Interner.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                CDOIDTempObjectExternalImpl id = (CDOIDTempObjectExternalImpl)entry.get();
                if (id != null && id.uri.equals(uri)) {
                    return id;
                }
                entry = entry.getNextEntry();
            }
            CDOIDTempObjectExternalImpl id = new CDOIDTempObjectExternalImpl(uri, null);
            this.addEntry(this.createEntry(id, hashCode));
            return id;
        }

        protected int hashCode(CDOIDTempObjectExternalImpl id) {
            return CDOIDTempObjectExternalImpl.getHashCode(id.uri);
        }
    }
}

