/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueBytes
extends Value {
    private static final ValueBytes EMPTY = new ValueBytes(Utils.EMPTY_BYTES);
    protected byte[] value;
    protected int hash;

    protected ValueBytes(byte[] byArray) {
        this.value = byArray;
    }

    public static ValueBytes get(byte[] byArray) {
        if (byArray.length == 0) {
            return EMPTY;
        }
        byArray = Utils.cloneByteArray(byArray);
        return ValueBytes.getNoCopy(byArray);
    }

    public static ValueBytes getNoCopy(byte[] byArray) {
        if (byArray.length == 0) {
            return EMPTY;
        }
        ValueBytes valueBytes = new ValueBytes(byArray);
        if (byArray.length > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return valueBytes;
        }
        return (ValueBytes)Value.cache(valueBytes);
    }

    public int getType() {
        return 12;
    }

    public String getSQL() {
        return "X'" + StringUtils.convertBytesToHex(this.getBytesNoCopy()) + "'";
    }

    public byte[] getBytesNoCopy() {
        return this.value;
    }

    public byte[] getBytes() {
        return Utils.cloneByteArray(this.getBytesNoCopy());
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        byte[] byArray = ((ValueBytes)value).value;
        return Utils.compareNotNull(this.value, byArray);
    }

    public String getString() {
        return StringUtils.convertBytesToHex(this.value);
    }

    public long getPrecision() {
        return this.value.length;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Utils.getByteArrayHash(this.value);
        }
        return this.hash;
    }

    public Object getObject() {
        return this.getBytes();
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBytes(n, this.value);
    }

    public int getDisplaySize() {
        return MathUtils.convertLongToInt((long)this.value.length * 2L);
    }

    public int getMemory() {
        return this.value.length + 24;
    }

    public boolean equals(Object object) {
        return object instanceof ValueBytes && Utils.compareNotNull(this.value, ((ValueBytes)object).value) == 0;
    }

    public Value convertPrecision(long l, boolean bl) {
        if ((long)this.value.length <= l) {
            return this;
        }
        int n = MathUtils.convertLongToInt(l);
        byte[] byArray = new byte[n];
        System.arraycopy(this.value, 0, byArray, 0, n);
        return ValueBytes.get(byArray);
    }
}

