/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j;

import org.eclipse.emf.cdo.internal.net4j.RecoveringCDOSessionImpl;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public class FailoverCDOSessionImpl
extends RecoveringCDOSessionImpl {
    private String monitorConnectorDescription;
    private String repositoryGroup;

    public void setMonitorConnectionDescription(String monitorConnectorDescription) {
        this.monitorConnectorDescription = monitorConnectorDescription;
    }

    public void setRepositoryGroup(String repositoryGroup) {
        this.repositoryGroup = repositoryGroup;
    }

    @Override
    protected void updateConnectorAndRepositoryName() {
        this.queryRepositoryInfoFromMonitor();
        IConnector connector = this.createTCPConnector(this.getUseHeartBeat());
        this.setConnector(connector);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void queryRepositoryInfoFromMonitor() {
        IConnector connector = this.getTCPConnector(this.monitorConnectorDescription);
        SignalProtocol protocol = new SignalProtocol("failover-client");
        protocol.open(connector);
        try {
            try {
                String oldRepositoryConnectorDescription = this.getRepositoryConnectorDescription();
                String oldRepositoryName = this.getRepositoryName();
                while (ObjectUtil.equals((Object)this.getRepositoryConnectorDescription(), (Object)oldRepositoryConnectorDescription)) {
                    if (!ObjectUtil.equals((Object)this.getRepositoryName(), (Object)oldRepositoryName)) {
                        return;
                    }
                    new RequestWithConfirmation<Boolean>(protocol, 1, "QueryRepositoryInfo"){

                        protected void requesting(ExtendedDataOutputStream out) throws Exception {
                            out.writeString(FailoverCDOSessionImpl.this.repositoryGroup);
                        }

                        protected Boolean confirming(ExtendedDataInputStream in) throws Exception {
                            FailoverCDOSessionImpl.this.setRepositoryConnectorDescription(in.readString());
                            FailoverCDOSessionImpl.this.setRepositoryName(in.readString());
                            return true;
                        }
                    }.send();
                }
                return;
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        finally {
            protocol.close();
            if (connector.getChannels().isEmpty()) {
                connector.close();
            }
        }
    }
}

