/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jms;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import org.eclipse.net4j.internal.jms.DestinationImpl;
import org.eclipse.net4j.internal.jms.MessageConsumerImpl;
import org.eclipse.net4j.internal.jms.NotYetImplementedException;
import org.eclipse.net4j.internal.jms.SessionImpl;
import org.eclipse.net4j.internal.jms.messages.Messages;
import org.eclipse.net4j.internal.jms.util.DestinationUtil;
import org.eclipse.net4j.internal.jms.util.TypeUtil;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
implements Message,
Comparable<MessageImpl> {
    private static final String[] KEYWORDS = new String[]{"and", "between", "escape", "in", "is", "like", "false", "null", "or", "not", "true"};
    private Map<String, Object> properties = new HashMap<String, Object>();
    private byte[] correlationID;
    private int deliveryMode;
    private DestinationImpl destination;
    private long expiration;
    private String messageID;
    private int priority;
    private boolean redelivered;
    private DestinationImpl replyTo;
    private long timestamp;
    private String type;
    private SessionImpl receivingSession;
    private MessageConsumerImpl receivingConsumer;

    public SessionImpl getReceivingSession() {
        return this.receivingSession;
    }

    public void setReceivingSession(SessionImpl receivingSession) {
        this.receivingSession = receivingSession;
    }

    public MessageConsumerImpl getReceivingConsumer() {
        return this.receivingConsumer;
    }

    public void setReceivingConsumer(MessageConsumerImpl receivingConsumer) {
        this.receivingConsumer = receivingConsumer;
    }

    public String getJMSCorrelationID() {
        if (this.correlationID == null) {
            return null;
        }
        return new String(this.correlationID);
    }

    public void setJMSCorrelationID(String correlationID) {
        this.correlationID = correlationID == null ? null : correlationID.getBytes();
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.correlationID;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.correlationID = correlationID;
    }

    public int getJMSDeliveryMode() {
        return this.deliveryMode;
    }

    public void setJMSDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public Destination getJMSDestination() {
        return this.destination;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.destination = DestinationUtil.convert(destination);
    }

    public long getJMSExpiration() {
        return this.expiration;
    }

    public void setJMSExpiration(long expiration) {
        this.expiration = expiration;
    }

    public String getJMSMessageID() {
        return this.messageID;
    }

    public void setJMSMessageID(String messageID) {
        this.messageID = messageID;
    }

    public int getJMSPriority() {
        return this.priority;
    }

    public void setJMSPriority(int priority) {
        this.priority = priority;
    }

    public boolean getJMSRedelivered() {
        return this.redelivered;
    }

    public void setJMSRedelivered(boolean redelivered) {
        this.redelivered = redelivered;
    }

    public Destination getJMSReplyTo() {
        return this.replyTo;
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.replyTo = DestinationUtil.convert(replyTo);
    }

    public long getJMSTimestamp() {
        return this.timestamp;
    }

    public void setJMSTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getJMSType() {
        return this.type;
    }

    public void setJMSType(String type) {
        this.type = type;
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public boolean propertyExists(String name) {
        return this.properties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) throws MessageFormatException {
        return TypeUtil.getBoolean(this.properties.get(name));
    }

    public byte getByteProperty(String name) throws MessageFormatException {
        return TypeUtil.getByte(this.properties.get(name));
    }

    public short getShortProperty(String name) throws MessageFormatException {
        return TypeUtil.getShort(this.properties.get(name));
    }

    public int getIntProperty(String name) throws MessageFormatException {
        return TypeUtil.getInt(this.properties.get(name));
    }

    public long getLongProperty(String name) throws MessageFormatException {
        return TypeUtil.getLong(this.properties.get(name));
    }

    public float getFloatProperty(String name) throws MessageFormatException {
        return TypeUtil.getFloat(this.properties.get(name));
    }

    public double getDoubleProperty(String name) throws MessageFormatException {
        return TypeUtil.getDouble(this.properties.get(name));
    }

    public String getStringProperty(String name) throws MessageFormatException {
        return TypeUtil.getString(this.properties.get(name));
    }

    public Object getObjectProperty(String name) {
        return this.properties.get(name);
    }

    public Enumeration<String> getPropertyNames() {
        return Collections.enumeration(this.properties.keySet());
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setProperty(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.setProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.setProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.setProperty(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.setProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.setProperty(name, Float.valueOf(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.setProperty(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.setProperty(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value == null)) {
            throw new MessageFormatException(MessageFormat.format(Messages.getString("MessageImpl_11"), value.getClass().getName()));
        }
        this.setProperty(name, value);
    }

    protected void setProperty(String name, Object value) throws JMSException {
        if (name == null) {
            throw new JMSException(MessageFormat.format(Messages.getString("MessageImpl_13"), name));
        }
        char[] chars = name.toCharArray();
        if (chars.length == 0) {
            throw new JMSException(MessageFormat.format(Messages.getString("MessageImpl_13"), name));
        }
        if (!Character.isJavaIdentifierStart(chars[0])) {
            throw new JMSException(MessageFormat.format(Messages.getString("MessageImpl_13"), name));
        }
        int i = 1;
        while (i < chars.length) {
            if (!Character.isJavaIdentifierPart(chars[i])) {
                throw new JMSException(MessageFormat.format(Messages.getString("MessageImpl_13"), name));
            }
            ++i;
        }
        i = 0;
        while (i < KEYWORDS.length) {
            if (name.equalsIgnoreCase(KEYWORDS[i])) {
                throw new JMSException(MessageFormat.format(Messages.getString("MessageImpl_13"), name));
            }
            ++i;
        }
        this.properties.put(name, value);
    }

    public void acknowledge() {
        if (this.receivingSession == null) {
            return;
        }
        if (!this.receivingSession.isActive()) {
            return;
        }
        if (this.receivingSession.getTransacted()) {
            return;
        }
        if (this.receivingSession.getAcknowledgeMode() != 2) {
            return;
        }
        this.receivingSession.acknowledgeMessages(this.receivingConsumer);
    }

    public void clearBody() {
        throw new NotYetImplementedException();
    }

    @Override
    public int compareTo(MessageImpl obj) {
        if (this.priority < obj.priority) {
            return -1;
        }
        if (this.priority > obj.priority) {
            return 1;
        }
        return 0;
    }

    public void populate(Message source) throws JMSException {
        this.setJMSMessageID(source.getJMSMessageID());
        this.setJMSDestination(source.getJMSDestination());
        this.setJMSTimestamp(source.getJMSTimestamp());
        this.setJMSPriority(source.getJMSPriority());
        this.setJMSExpiration(source.getJMSExpiration());
        this.setJMSDeliveryMode(source.getJMSDeliveryMode());
        this.setJMSCorrelationID(source.getJMSCorrelationID());
        this.setJMSType(source.getJMSType());
        this.setJMSReplyTo(source.getJMSReplyTo());
        Enumeration e = source.getPropertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object value = source.getObjectProperty(name);
            this.setObjectProperty(name, value);
        }
    }

    public void write(ExtendedDataOutputStream out) throws IOException {
        out.writeByteArray(this.correlationID);
        out.writeByte(this.deliveryMode);
        DestinationUtil.write(out, this.destination);
        out.writeLong(this.expiration);
        out.writeString(this.messageID);
        out.writeByte(this.priority);
        out.writeBoolean(this.redelivered);
        DestinationUtil.write(out, this.replyTo);
        out.writeLong(this.timestamp);
        out.writeString(this.type);
        out.writeInt(this.properties.size());
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            out.writeString(entry.getKey());
            TypeUtil.write(out, entry.getValue());
        }
    }

    public void read(ExtendedDataInputStream in) throws IOException {
        this.correlationID = in.readByteArray();
        this.deliveryMode = in.readByte();
        this.destination = DestinationUtil.read(in);
        this.expiration = in.readLong();
        this.messageID = in.readString();
        this.priority = in.readByte();
        this.redelivered = in.readBoolean();
        this.replyTo = DestinationUtil.read(in);
        this.timestamp = in.readLong();
        this.type = in.readString();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            String key = in.readString();
            Object value = TypeUtil.read(in);
            this.properties.put(key, value);
            ++i;
        }
    }
}

