/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.util;

import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.InvalidURIException;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOURIData {
    public static final String BRANCH_PARAMETER = "branch";
    public static final String TIME_PARAMETER = "time";
    public static final String VIEW_ID_PARAMETER = "view";
    public static final String TRANSACTIONAL_PARAMETER = "transactional";
    private String scheme;
    private String userName;
    private String passWord;
    private String authority;
    private String repositoryName;
    private IPath resourcePath;
    private IPath branchPath = new Path("MAIN");
    private long timeStamp = 0L;
    private String viewID;
    private boolean transactional;
    private Map<String, String> extraParameters;

    public CDOURIData() {
    }

    public CDOURIData(String uri) throws InvalidURIException {
        this(URI.createURI((String)uri));
    }

    public CDOURIData(URI uri) throws InvalidURIException {
        try {
            String query;
            this.scheme = uri.scheme();
            this.authority = uri.authority();
            String userInfo = uri.userInfo();
            if (userInfo != null) {
                this.authority = this.authority.substring(userInfo.length() + 1);
                int colon = userInfo.indexOf(58);
                if (colon != -1) {
                    this.userName = userInfo.substring(0, colon);
                    this.passWord = userInfo.substring(colon + 1);
                } else {
                    this.userName = userInfo;
                }
            }
            IPath path = new Path(uri.path()).makeAbsolute();
            this.repositoryName = path.segment(0);
            this.resourcePath = path.removeFirstSegments(1);
            if (this.resourcePath == null || this.resourcePath.isEmpty()) {
                this.resourcePath = new Path(CDOURIUtil.SEGMENT_SEPARATOR);
            }
            if ((query = uri.query()) != null && query.length() != 0) {
                String time;
                Map<String, String> parameters = CDOURIUtil.getParameters(query);
                String branch = parameters.remove(BRANCH_PARAMETER);
                if (branch != null) {
                    this.branchPath = new Path(branch).makeRelative();
                }
                if ((time = parameters.remove(TIME_PARAMETER)) != null && !"HEAD".equalsIgnoreCase(time)) {
                    this.timeStamp = Long.parseLong(time);
                }
                this.viewID = parameters.remove(VIEW_ID_PARAMETER);
                String transactional = parameters.remove(TRANSACTIONAL_PARAMETER);
                if (transactional != null) {
                    this.transactional = Boolean.parseBoolean(transactional);
                }
                if (!parameters.isEmpty()) {
                    this.extraParameters = parameters;
                }
            }
            if (this.timeStamp != 0L && this.transactional) {
                throw new IllegalArgumentException("Only HEAD can be transactional");
            }
        }
        catch (Throwable t) {
            throw new InvalidURIException(uri, t);
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public IPath getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(IPath resourcePath) {
        this.resourcePath = resourcePath;
    }

    public IPath getBranchPath() {
        return this.branchPath;
    }

    public void setBranchPath(IPath branchPath) {
        this.branchPath = branchPath;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getViewID() {
        return this.viewID;
    }

    public void setViewID(String viewID) {
        this.viewID = viewID;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public Map<String, String> getExtraParameters() {
        return this.extraParameters;
    }

    public void setExtraParameters(Map<String, String> extraParameters) {
        this.extraParameters = extraParameters;
    }

    public URI toURI() {
        return URI.createURI((String)this.toString());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.scheme);
        builder.append("://");
        if (this.userName != null) {
            builder.append(this.userName);
            if (this.passWord != null) {
                builder.append(":");
                builder.append(this.passWord);
            }
            builder.append("@");
        }
        builder.append(this.authority);
        builder.append("/");
        builder.append(this.repositoryName);
        if (this.resourcePath != null) {
            builder.append("/");
            builder.append(this.resourcePath);
        }
        int params = 0;
        if (this.branchPath != null && !this.branchPath.equals((Object)new Path("MAIN"))) {
            builder.append(params++ == 0 ? "?" : "&");
            builder.append(BRANCH_PARAMETER);
            builder.append("=");
            builder.append(this.branchPath.toPortableString());
        }
        if (this.timeStamp != 0L) {
            builder.append(params++ == 0 ? "?" : "&");
            builder.append(TIME_PARAMETER);
            builder.append("=");
            builder.append(this.timeStamp);
        }
        if (this.viewID != null) {
            builder.append(params++ == 0 ? "?" : "&");
            builder.append(VIEW_ID_PARAMETER);
            builder.append("=");
            builder.append(this.viewID);
        }
        if (this.transactional) {
            builder.append(params++ == 0 ? "?" : "&");
            builder.append(TRANSACTIONAL_PARAMETER);
            builder.append("=");
            builder.append(this.transactional);
        }
        if (this.extraParameters != null) {
            for (Map.Entry<String, String> entry : this.extraParameters.entrySet()) {
                builder.append(params++ == 0 ? "?" : "&");
                builder.append(entry.getKey());
                builder.append("=");
                builder.append(entry.getValue());
            }
        }
        return builder.toString();
    }
}

