/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests.cache;

import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.net4j.util.ref.KeyedWeakReference;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public class SensitiveProtoTest
extends AbstractOMTest {
    public void testSensitiveCacheWithEvictionPolicy() throws Exception {
        KeyedAndValuedWeakReference ref;
        ConcurrentHashMap<Integer, KeyedAndValuedWeakReference<Integer, String>> map = new ConcurrentHashMap<Integer, KeyedAndValuedWeakReference<Integer, String>>();
        ReferenceQueue queue = new ReferenceQueue();
        int i = 0;
        while (i < 20) {
            map.put(i, new KeyedAndValuedWeakReference<Integer, String>(i, String.valueOf(i), queue));
            ++i;
        }
        int gc = 0;
        while (gc < 10) {
            System.gc();
            SensitiveProtoTest.sleep(100L);
            ++gc;
        }
        while ((ref = (KeyedAndValuedWeakReference)((Object)queue.poll())) != null) {
            int i2 = (Integer)ref.getKey();
            System.out.println("Dequeued i=" + i2);
            if (i2 < 10) {
                map.put(i2, new KeyedAndValuedWeakReference<Integer, String>(i2, (String)ref.getValue(), queue));
                continue;
            }
            map.remove(i2, (Object)ref);
        }
        SensitiveProtoTest.assertEquals((int)10, (int)map.size());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyedAndValuedWeakReference<K, T>
    extends KeyedWeakReference<K, T> {
        private T value;

        public KeyedAndValuedWeakReference(K key, T ref, ReferenceQueue<T> queue) {
            super(key, ref, queue);
            this.value = ref;
        }

        public KeyedAndValuedWeakReference(K key, T ref) {
            super(key, ref);
            this.value = ref;
        }

        public T getValue() {
            return this.value;
        }
    }
}

