/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.CharBuffer;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.io.IOUtil;

public class ExpectedFileReader
extends FileReader {
    private long timeout = IOUtil.DEFAULT_TIMEOUT;
    private File file;
    private long expectedSize;
    private long pos;

    public ExpectedFileReader(File file, long expectedSize) throws FileNotFoundException {
        super(file);
        this.file = file;
        this.expectedSize = expectedSize;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long skip(long n) throws IOException {
        this.waitForInput(n);
        return super.skip(n);
    }

    public int read() throws IOException {
        this.waitForInput(1L);
        return super.read();
    }

    public int read(char[] cbuf, int offset, int length) throws IOException {
        this.waitForInput(length);
        return super.read(cbuf, offset, length);
    }

    public int read(CharBuffer target) throws IOException {
        this.waitForInput(target.remaining());
        return super.read(target);
    }

    public int read(char[] cbuf) throws IOException {
        this.waitForInput(cbuf.length);
        return super.read(cbuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInput(long n) throws IOException {
        ExpectedFileReader expectedFileReader = this;
        synchronized (expectedFileReader) {
            n = Math.min(n, this.expectedSize - this.pos);
            long restSize = this.file.length() - this.pos;
            long endTime = 0L;
            while (restSize < n) {
                long restTime;
                if (endTime == 0L) {
                    endTime = System.currentTimeMillis() + this.timeout;
                    restTime = this.timeout;
                } else {
                    restTime = endTime - System.currentTimeMillis();
                }
                if (restTime <= 0L) {
                    throw new TimeoutRuntimeException("Timeout while reading from " + this.file.getAbsolutePath());
                }
                try {
                    this.wait(Math.max(100L, restTime));
                }
                catch (InterruptedException ex) {
                    throw WrappedException.wrap(ex);
                }
                restSize = this.file.length() - this.pos;
            }
            this.pos += n;
        }
    }
}

