/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.concurrent.IExecutorServiceProvider;
import org.eclipse.net4j.util.concurrent.IWorkSerializer;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class AsynchronousWorkSerializer
implements IWorkSerializer,
IExecutorServiceProvider,
Runnable {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_CONCURRENCY, AsynchronousWorkSerializer.class);
    private ExecutorService executorService;
    private Queue<Runnable> workQueue;
    private Occupation occupation = new Occupation();

    public AsynchronousWorkSerializer(ExecutorService executorService, Queue<Runnable> workQueue) {
        if (executorService == null) {
            throw new IllegalArgumentException("executorService == null");
        }
        this.executorService = executorService;
        this.workQueue = workQueue;
    }

    public AsynchronousWorkSerializer(ExecutorService executorService) {
        this(executorService, new ConcurrentLinkedQueue<Runnable>());
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addWork(Runnable work) {
        this.workQueue.add(work);
        if (!this.occupation.isOccupied()) {
            Occupation occupation = this.occupation;
            synchronized (occupation) {
                this.occupation.setOccupied(true);
            }
            if (TRACER.isEnabled()) {
                TRACER.trace("Notifying executor service");
            }
            this.executorService.execute(this);
        }
        return true;
    }

    @Override
    public void run() {
        Runnable work;
        while (this.occupation.isOccupied() && (work = this.workQueue.poll()) != null) {
            try {
                work.run();
            }
            catch (RuntimeException ex) {
                if (!TRACER.isEnabled()) continue;
                TRACER.trace(ex);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.occupation.isOccupied()) {
            this.occupation.setOccupied(false);
        }
        this.workQueue.clear();
        this.workQueue = null;
        this.executorService = null;
    }

    public String toString() {
        return AsynchronousWorkSerializer.class.getSimpleName();
    }

    private static final class Occupation {
        private boolean occupied;

        private Occupation() {
        }

        public boolean isOccupied() {
            return this.occupied;
        }

        public void setOccupied(boolean occupied) {
            this.occupied = occupied;
        }
    }
}

