/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.collection.AbstractIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BidiMap<K, V>
extends AbstractMap<K, V> {
    private final Map<Object, Object> map;
    private final Class<K> keyClass;
    private final Class<V> valueClass;

    private BidiMap(Class<K> keyClass, Class<V> valueClass, Map<Object, Object> map) {
        CheckUtil.checkArg(keyClass != valueClass, "Key and value class are the same");
        CheckUtil.checkArg(!keyClass.isAssignableFrom(valueClass), "Key class is assignable from value class");
        CheckUtil.checkArg(!valueClass.isAssignableFrom(keyClass), "Value class is assignable from key class");
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.map = map;
    }

    public BidiMap(Class<K> keyClass, Class<V> valueClass) {
        this(keyClass, valueClass, new HashMap<Object, Object>());
    }

    public final Class<K> getKeyClass() {
        return this.keyClass;
    }

    public final Class<V> getValueClass() {
        return this.valueClass;
    }

    public final Map<V, K> invert() {
        return new BidiMap<V, K>(this.valueClass, this.keyClass, this.map);
    }

    @Override
    public V put(K key, V value) {
        CheckUtil.checkArg(key, "Key is null");
        CheckUtil.checkArg(value, "Value is null");
        Object oldValue = this.map.put(key, value);
        this.map.put(value, key);
        return (V)oldValue;
    }

    @Override
    public V remove(Object key) {
        if (this.keyClass.isInstance(key)) {
            Object oldValue = this.map.remove(key);
            if (oldValue != null) {
                this.map.remove(oldValue);
            }
            return (V)oldValue;
        }
        return null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size() / 2;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyClass.isInstance(key) && this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.invert().containsKey(value);
    }

    @Override
    public V get(Object key) {
        if (this.keyClass.isInstance(key)) {
            Object value = this.map.get(key);
            return (V)value;
        }
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator delegate = BidiMap.this.map.entrySet().iterator();
                return new AbstractIterator<Map.Entry<K, V>>(){

                    @Override
                    protected Object computeNextElement() {
                        while (delegate.hasNext()) {
                            Map.Entry element = (Map.Entry)delegate.next();
                            if (!BidiMap.this.keyClass.isInstance(element.getKey())) continue;
                            return element;
                        }
                        return END_OF_DATA;
                    }
                };
            }

            @Override
            public int size() {
                return BidiMap.this.size() / 2;
            }
        };
    }
}

