/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadPackagesRequest
extends CDOClientRequest<EPackage[]> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LoadPackagesRequest.class);
    private InternalCDOPackageUnit packageUnit;

    public LoadPackagesRequest(CDOClientProtocol protocol, InternalCDOPackageUnit packageUnit) {
        super(protocol, (short)6);
        this.packageUnit = packageUnit;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        String packageUnitID = this.packageUnit.getID();
        if (TRACER.isEnabled()) {
            TRACER.format("Writing packageUnitID: {0}", new Object[]{packageUnitID});
        }
        out.writeCDOPackageURI(packageUnitID);
    }

    @Override
    protected EPackage[] confirming(CDODataInput in) throws IOException {
        ResourceSet resourceSet = EMFUtil.newEcoreResourceSet((EPackage.Registry)this.packageUnit.getPackageRegistry());
        EPackage ePackage = CDOModelUtil.readPackage((ExtendedDataInput)in, (ResourceSet)resourceSet, (boolean)false);
        return EMFUtil.getAllPackages((EPackage)ePackage);
    }
}

