/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j;

import org.eclipse.emf.cdo.internal.net4j.CDONet4jSessionConfigurationImpl;
import org.eclipse.emf.cdo.internal.net4j.RecoveringCDOSessionImpl;
import org.eclipse.emf.cdo.net4j.RecoveringCDOSessionConfiguration;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.container.IManagedContainer;

public abstract class RecoveringCDOSessionConfigurationImpl
extends CDONet4jSessionConfigurationImpl
implements RecoveringCDOSessionConfiguration {
    private IManagedContainer container;
    private boolean heartBeatEnabled = false;
    private long heartBeatPeriod = 1000L;
    private long heartBeatTimeout = 5000L;
    private long connectorTimeout = 10000L;

    public RecoveringCDOSessionConfigurationImpl(IManagedContainer container) {
        this.container = container;
    }

    protected IManagedContainer getContainer() {
        return this.container;
    }

    public long getConnectorTimeout() {
        return this.connectorTimeout;
    }

    public void setConnectorTimeout(long timeout) {
        this.connectorTimeout = timeout;
    }

    public boolean isHeartBeatEnabled() {
        return this.heartBeatEnabled;
    }

    public void setHeartBeatEnabled(boolean enabled) {
        this.heartBeatEnabled = enabled;
    }

    public long getHeartBeatTimeout() {
        return this.heartBeatTimeout;
    }

    public void setHeartBeatTimeout(long timeout) {
        this.heartBeatTimeout = timeout;
    }

    public long getHeartBeatPeriod() {
        return this.heartBeatPeriod;
    }

    public void setHeartBeatPeriod(long period) {
        this.heartBeatPeriod = period;
    }

    protected void configureSession(InternalCDOSession session) {
        super.configureSession(session);
        if (this.heartBeatEnabled && (this.heartBeatPeriod == 0L || this.heartBeatTimeout == 0L)) {
            throw new IllegalStateException("Cannot use a heartbeat with zero value set for period or timeout.");
        }
        RecoveringCDOSessionImpl sessionImpl = (RecoveringCDOSessionImpl)session;
        sessionImpl.setContainer(this.getContainer());
        sessionImpl.setUseHeartBeat(this.heartBeatEnabled);
        sessionImpl.setHeartBeatPeriod(this.heartBeatPeriod);
        sessionImpl.setHeartBeatTimeout(this.heartBeatTimeout);
        sessionImpl.setConnectorTimeout(this.connectorTimeout);
    }
}

