/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ocl.transformations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ValidationMessages;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryCreationException;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryOperation;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QvtLibraryOperation {
    private static final String OCL_CONTEXT = "context";
    private static final String OCL_DEF = "def:";
    private static final String Common_SPACE = " ";
    private static final String Common_BRACKET_OPEN = "(";
    private static final String Common_BRACKET_CLOSE = ")";
    private static final String Common_COMMA = ",";
    private static final String Common_COLON = ":";
    private static final String Common_EQ = "=";
    private static final String PARAMETER_PREFIX = "param_";
    private final EClassifier myContextType;
    private final EClassifier myReturnType;
    private final List<EClassifier> myParamTypes;

    QvtLibraryOperation(QvtOperationalEnv parseEnv, LibraryOperation libOp) throws LibraryCreationException {
        String fakeOperation = this.getFakeOperation(libOp);
        ExpressionInOCL<EClassifier, EParameter> exprInOcl = this.parseConstraintUnvalidated(fakeOperation, parseEnv, libOp);
        this.myParamTypes = new ArrayList<EClassifier>(exprInOcl.getParameterVariable().size());
        for (Variable param : exprInOcl.getParameterVariable()) {
            if (param.getType() == null) {
                throw new LibraryCreationException(MessageFormat.format(ValidationMessages.LibOperationAnalyser_OperationParsingError, fakeOperation));
            }
            this.myParamTypes.add((EClassifier)param.getType());
        }
        if (exprInOcl.getContextVariable() == null) {
            throw new LibraryCreationException(MessageFormat.format(ValidationMessages.LibOperationAnalyser_OperationParsingError, fakeOperation));
        }
        this.myContextType = (EClassifier)exprInOcl.getContextVariable().getType();
        if (exprInOcl.getBodyExpression() == null) {
            throw new LibraryCreationException(MessageFormat.format(ValidationMessages.LibOperationAnalyser_OperationParsingError, fakeOperation));
        }
        this.myReturnType = (EClassifier)exprInOcl.getBodyExpression().getType();
    }

    public EClassifier getContextType() {
        return this.myContextType;
    }

    public EClassifier getReturnType() {
        return this.myReturnType;
    }

    public EClassifier[] getParamTypes() {
        return this.myParamTypes.toArray(new EClassifier[this.myParamTypes.size()]);
    }

    protected ExpressionInOCL<EClassifier, EParameter> parseConstraintUnvalidated(String text, QvtOperationalEnv env, LibraryOperation libOp) throws LibraryCreationException {
        OCL ocl = OCL.newInstance((Environment)env);
        Constraint constraint = null;
        try {
            if (QvtLibraryOperation.isOclVoidTypeName(libOp.getContext(), env)) {
                int startPos = text.indexOf(" def:") + OCL_DEF.length() + 1;
                String trimmedText = startPos < text.length() ? text.substring(startPos) : text;
                OCL.Helper helper = ocl.createOCLHelper();
                helper.setContext((Object)env.getModuleContextType());
                constraint = (Constraint)helper.createConstraint(ConstraintKind.DEFINITION, trimmedText);
            } else {
                List constraints = ocl.parse(new OCLInput(text));
                if (!constraints.isEmpty()) {
                    constraint = (Constraint)constraints.get(0);
                }
            }
        }
        catch (ParserException e) {
            throw new LibraryCreationException(MessageFormat.format(ValidationMessages.LibOperationAnalyser_ParametersOsReturnTypeNotFound, text, e.getLocalizedMessage()));
        }
        catch (IllegalArgumentException e) {
            throw new LibraryCreationException(MessageFormat.format(ValidationMessages.LibOperationAnalyser_ParametersOsReturnTypeNotFound, text, e.getLocalizedMessage()));
        }
        if (constraint == null) {
            throw new LibraryCreationException(MessageFormat.format(ValidationMessages.LibOperationAnalyser_OperationParsingError, text));
        }
        ExpressionInOCL result = constraint.getSpecification();
        if (result == null) {
            throw new LibraryCreationException(MessageFormat.format(ValidationMessages.LibOperationAnalyser_OperationParsingError, text));
        }
        try {
            if (result.toString() == null) {
                throw new LibraryCreationException(MessageFormat.format(ValidationMessages.LibOperationAnalyser_OperationParsingError, text));
            }
        }
        catch (RuntimeException e) {
            throw new LibraryCreationException(MessageFormat.format(ValidationMessages.LibOperationAnalyser_OperationParsingError, text));
        }
        return result;
    }

    private static boolean isOclVoidTypeName(String typeName, QvtOperationalEnv env) {
        UMLReflection umlReflection = env.getUMLReflection();
        EClassifier oclVoid = (EClassifier)env.getOCLStandardLibrary().getOclVoid();
        String simpleName = umlReflection.getName((Object)oclVoid);
        String qName = umlReflection.getQualifiedName((Object)oclVoid);
        return typeName.equals(simpleName) || typeName.equals(qName);
    }

    private String getFakeOperation(LibraryOperation libOp) {
        StringBuffer result = new StringBuffer();
        result.append(OCL_CONTEXT);
        result.append(Common_SPACE);
        result.append(libOp.getContext());
        result.append(Common_SPACE);
        result.append(OCL_DEF);
        result.append(Common_SPACE);
        result.append(libOp.getName());
        result.append(Common_BRACKET_OPEN);
        int counter = 0;
        for (String nextType : libOp.getParameterTypes()) {
            String nextParameterType = this.getFakeTypeText(nextType);
            if (counter > 0) {
                result.append(Common_COMMA);
            }
            result.append(PARAMETER_PREFIX);
            result.append(counter);
            result.append(Common_COLON);
            result.append(nextParameterType);
            ++counter;
        }
        result.append(Common_BRACKET_CLOSE);
        result.append(Common_COLON);
        result.append(this.getFakeTypeText(libOp.getReturnType()));
        result.append(Common_EQ).append("let r:");
        result.append(this.getFakeTypeText(libOp.getReturnType()));
        result.append(Common_EQ);
        result.append("null in r");
        return result.toString();
    }

    private String getFakeTypeText(String type) {
        return type != null ? type : "OclAny";
    }
}

