/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project.builder;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.project.QVTOProjectPlugin;
import org.eclipse.m2m.internal.qvt.oml.project.builder.WorkspaceUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.DeployedImportResolver;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.PlatformPluginUnitResolver;

public class EclipseUnitResolverFactory
implements UnitResolverFactory {
    public boolean isAccepted(Object source) {
        if (source instanceof IResource) {
            return true;
        }
        if (source instanceof URI) {
            URI uri = (URI)source;
            return uri.isPlatform() || EclipseUnitResolverFactory.isWorkspacePath(uri) || EclipseUnitResolverFactory.isDeployedByID(uri);
        }
        return false;
    }

    public UnitProxy findUnit(URI unitURI) {
        if (unitURI.isPlatformResource()) {
            IFile file = URIUtils.getFile((URI)unitURI);
            if (file != null) {
                return WorkspaceUnitResolver.getUnit(file);
            }
        } else {
            if (unitURI.isPlatformPlugin()) {
                return PlatformPluginUnitResolver.getUnit((URI)unitURI);
            }
            if (EclipseUnitResolverFactory.isWorkspacePath(unitURI)) {
                URI platformResourceURI = URI.createPlatformResourceURI((String)unitURI.path(), (boolean)false);
                IFile file = URIUtils.getFile((URI)platformResourceURI);
                if (file != null) {
                    return WorkspaceUnitResolver.getUnit(file);
                }
            } else if (EclipseUnitResolverFactory.isDeployedByID(unitURI)) {
                return DeployedImportResolver.INSTANCE.resolveDeployedUnitOnly(unitURI.path());
            }
        }
        return null;
    }

    public UnitResolver getResolver(URI uri) {
        IResource resource = URIUtils.getResource((URI)uri);
        if (resource.exists()) {
            try {
                return WorkspaceUnitResolver.getResolver(resource.getProject());
            }
            catch (CoreException e) {
                QVTOProjectPlugin.log(e);
            }
        }
        return null;
    }

    private static boolean isWorkspacePath(URI uri) {
        return uri.scheme() == null && !uri.hasDevice() && !uri.hasAuthority() && !uri.hasEmptyPath() && !uri.hasQuery() && !uri.hasFragment() && uri.hasAbsolutePath();
    }

    private static boolean isDeployedByID(URI uri) {
        return uri.scheme() == null && !uri.hasDevice() && !uri.hasAuthority() && !uri.hasEmptyPath() && !uri.hasQuery() && !uri.hasFragment() && !uri.hasAbsolutePath();
    }
}

