/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4mp.commons.ClasspathKind;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileProjectInfo;
import org.eclipse.lsp4mp.commons.MicroProfilePropertiesScope;
import org.eclipse.lsp4mp.jdt.core.JavaUtils;
import org.eclipse.lsp4mp.jdt.core.PropertiesManager;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.internal.core.java.validators.JavaASTValidatorRegistry;
import org.eclipse.lsp4mp.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class BasePropertiesManagerTest {
    private static final Logger LOGGER = Logger.getLogger(BasePropertiesManagerTest.class.getSimpleName());
    private static Level oldLevel;
    protected static IJDTUtils JDT_UTILS;

    static {
        JDT_UTILS = JDTUtilsLSImpl.getInstance();
    }

    @BeforeClass
    public static void setUp() {
        oldLevel = LOGGER.getLevel();
        LOGGER.setLevel(Level.INFO);
        BasePropertiesManagerTest.enableClassFileContentsSupport();
        JavaASTValidatorRegistry.getInstance().getRules();
    }

    @AfterClass
    public static void tearDown() {
        LOGGER.setLevel(oldLevel);
    }

    protected static void setJDTUtils(IJDTUtils newUtils) {
        JDT_UTILS = newUtils;
    }

    protected static MicroProfileProjectInfo getMicroProfileProjectInfoFromMavenProject(String mavenProject) throws CoreException, Exception, JavaModelException {
        return BasePropertiesManagerTest.getMicroProfileProjectInfoFromMavenProject(mavenProject, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
    }

    protected static MicroProfileProjectInfo getMicroProfileProjectInfoFromMavenProject(String mavenProject, List<MicroProfilePropertiesScope> scopes) throws CoreException, Exception, JavaModelException {
        IJavaProject javaProject = BasePropertiesManagerTest.loadMavenProject(mavenProject);
        return PropertiesManager.getInstance().getMicroProfileProjectInfo(javaProject, scopes, ClasspathKind.SRC, JDT_UTILS, DocumentFormat.Markdown, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IJavaProject loadMavenProject(String mavenProject) throws CoreException, Exception {
        return BasePropertiesManagerTest.loadJavaProjects(new String[]{"maven/" + mavenProject})[0];
    }

    public static IJavaProject loadGradleProject(String gradleProject) throws CoreException, Exception {
        IJavaProject gradleJavaProject = BasePropertiesManagerTest.loadJavaProjects(new String[]{"gradle/" + gradleProject})[0];
        Job.getJobManager().join((Object)"org.eclipse.buildship.core.jobs", (IProgressMonitor)new NullProgressMonitor());
        return gradleJavaProject;
    }

    public static IJavaProject loadMavenProjectFromSubFolder(String mavenProject, String subFolder) throws Exception {
        return BasePropertiesManagerTest.loadJavaProjects(new String[]{"maven/" + subFolder + "/" + mavenProject})[0];
    }

    public static IJavaProject[] loadJavaProjects(String[] parentSlashName) throws CoreException, Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        String[] stringArray = parentSlashName;
        int n = parentSlashName.length;
        int n2 = 0;
        while (n2 < n) {
            String parentSlashNameEntry = stringArray[n2];
            String parentDirName = parentSlashNameEntry.substring(0, parentSlashNameEntry.lastIndexOf(47));
            String projectName = parentSlashNameEntry.substring(parentSlashNameEntry.lastIndexOf(47) + 1);
            File projectFolder = BasePropertiesManagerTest.copyProjectToWorkingDirectory(projectName, parentDirName);
            Path path = new Path(projectFolder.getAbsolutePath());
            paths.add(path);
            ++n2;
        }
        JavaLanguageServerPlugin.getPreferencesManager();
        PreferenceManager.initialize();
        JavaLanguageServerPlugin.getPreferencesManager().updateClientPrefences(new ClientCapabilities(), new HashMap());
        JavaLanguageServerPlugin.getProjectsManager().initializeProjects(paths, null);
        NullProgressMonitor monitor = new NullProgressMonitor();
        BasePropertiesManagerTest.waitForBackgroundJobs((IProgressMonitor)monitor);
        JobHelpers.waitUntilIndexesReady();
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
        for (IPath iPath : paths) {
            IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription(iPath.append(".project"));
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
            javaProjects.add(JavaCore.create((IProject)project));
        }
        return javaProjects.toArray(new IJavaProject[0]);
    }

    private static File copyProjectToWorkingDirectory(String projectName, String parentDirName) throws IOException {
        File from = new File("projects/" + parentDirName + "/" + projectName);
        File to = new File(JavaUtils.getWorkingProjectDirectory(), Paths.get(parentDirName, projectName).toString());
        if (to.exists()) {
            FileUtils.forceDelete((File)to);
        }
        if (from.isDirectory()) {
            FileUtils.copyDirectory((File)from, (File)to);
        } else {
            FileUtils.copyFile((File)from, (File)to);
        }
        return to;
    }

    private static void waitForBackgroundJobs(IProgressMonitor monitor) throws Exception {
        org.eclipse.lsp4mp.jdt.internal.core.JobHelpers.waitForJobsToComplete(monitor);
    }

    private static void createFile(IFile file, String contents) throws CoreException {
        BasePropertiesManagerTest.createParentFolders((IResource)file);
        file.refreshLocal(0, null);
        ByteArrayInputStream fileContents = new ByteArrayInputStream(contents.getBytes());
        if (file.exists()) {
            file.setContents((InputStream)fileContents, 0, null);
        } else {
            file.create((InputStream)fileContents, true, null);
        }
    }

    private static void createParentFolders(IResource resource) throws CoreException {
        if (resource == null || resource.exists()) {
            return;
        }
        if (!resource.getParent().exists()) {
            BasePropertiesManagerTest.createParentFolders((IResource)resource.getParent());
        }
        switch (resource.getType()) {
            case 2: {
                ((IFolder)resource).create(1, true, (IProgressMonitor)new NullProgressMonitor());
                break;
            }
            case 4: {
                ((IProject)resource).create((IProgressMonitor)new NullProgressMonitor());
                ((IProject)resource).open((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    private static void updateFile(IFile file, String content) throws CoreException {
        try {
            Thread.sleep(1050L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        BasePropertiesManagerTest.createFile(file, content);
    }

    protected static void saveFile(String configFileName, String content, IJavaProject javaProject) throws CoreException {
        BasePropertiesManagerTest.saveFile(configFileName, content, javaProject, false);
    }

    protected static void saveFile(String configFileName, String content, IJavaProject javaProject, boolean inSource) throws CoreException {
        IFile file = BasePropertiesManagerTest.getFile(configFileName, javaProject, inSource);
        BasePropertiesManagerTest.updateFile(file, content);
    }

    protected static void deleteFile(String configFileName, IJavaProject javaProject) throws IOException, CoreException {
        BasePropertiesManagerTest.deleteFile(configFileName, javaProject, false);
    }

    protected static void deleteFile(String configFileName, IJavaProject javaProject, boolean inSource) throws IOException, CoreException {
        IFile file = BasePropertiesManagerTest.getFile(configFileName, javaProject, inSource);
        file.delete(true, (IProgressMonitor)new NullProgressMonitor());
    }

    private static IFile getFile(String configFileName, IJavaProject javaProject, boolean inSource) throws JavaModelException {
        if (inSource) {
            return javaProject.getProject().getFile((IPath)new Path("src/main/java/" + configFileName));
        }
        IPath output = javaProject.getOutputLocation();
        IPath filePath = output.append(configFileName);
        return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
    }

    private static void enableClassFileContentsSupport() {
        HashMap<String, String> extendedClientCapabilities = new HashMap<String, String>();
        extendedClientCapabilities.put("classFileContentsSupport", "true");
        JavaLanguageServerPlugin.getPreferencesManager().updateClientPrefences(new ClientCapabilities(), extendedClientCapabilities);
    }

    public static class GradleProjectName {
        public static String empty_gradle_project = "empty-gradle-project";
        public static String quarkus_gradle_project = "quarkus-gradle-project";
        public static String renamed_quarkus_gradle_project = "renamed-gradle";
    }

    public static class MicroProfileMavenProjectName {
        public static String all_quarkus_extensions = "all-quarkus-extensions";
        public static String config_hover = "config-hover";
        public static String config_properties = "config-properties";
        public static String config_quickstart = "config-quickstart";
        public static String config_quickstart_test = "config-quickstart-test";
        public static String empty_maven_project = "empty-maven-project";
        public static String other_empty_maven_project = "empty-maven-project";
        public static String folder_name_different_maven = "folder-name-different-maven";
        public static String hibernate_orm_resteasy = "hibernate-orm-resteasy";
        public static String hibernate_orm_resteasy_yaml = "hibernate-orm-resteasy-yaml";
        public static String microprofile_applicationpath = "microprofile-applicationpath";
        public static String microprofile_configproperties = "microprofile-configproperties";
        public static String microprofile_fault_tolerance = "microprofile-fault-tolerance";
        public static String microprofile_health_quickstart = "microprofile-health-quickstart";
        public static String microprofile_health_3 = "microprofile-health-3";
        public static String microprofile_lra = "microprofile-lra";
        public static String microprofile_context_propagation = "microprofile-context-propagation";
        public static String microprofile_metrics = "microprofile-metrics";
        public static String microprofile_opentracing = "microprofile-opentracing";
        public static String microprofile_openapi = "microprofile-openapi";
        public static String microprofile_reactive_messaging = "microprofile-reactive-messaging";
        public static String microprofile_graphql = "microprofile-graphql";
        public static String microprofile_jwt_quickstart = "microprofile-jwt-quickstart";
        public static String rest_client_ee9 = "rest-client-ee9";
        public static String rest_client_quickstart = "rest-client-quickstart";
        public static String using_vertx = "using-vertx";
        public static String open_liberty = "open-liberty";
    }
}

