/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.internal;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4j.Range;

public final class IdentifierUtil {
    public static Range computeIdentifierRange(IDocument document, int offset) throws BadLocationException {
        Region region = IdentifierUtil.computeIdentifierRegion(document, offset);
        int start = region.getOffset();
        int end = start + region.getLength();
        return new Range(LSPEclipseUtils.toPosition(start, document), LSPEclipseUtils.toPosition(end, document));
    }

    public static Region computeIdentifierRegion(IDocument document, int offset) throws BadLocationException {
        int docLength = document.getLength();
        if (offset < 0 || offset > docLength) {
            throw new BadLocationException();
        }
        int start = offset;
        while (start > 0 && IdentifierUtil.isIdentifierPart(document, start - 1)) {
            --start;
        }
        int end = offset;
        while (end < docLength && IdentifierUtil.isIdentifierPart(document, end)) {
            ++end;
        }
        return new Region(start, end - start);
    }

    public static boolean isIdentifierPart(char ch) {
        return Character.isUnicodeIdentifierPart(ch);
    }

    public static boolean isIdentifierPart(IDocument document, int offset) throws BadLocationException {
        return IdentifierUtil.isIdentifierPart(document.getChar(offset));
    }

    private IdentifierUtil() {
    }
}

