/**
 */
package distributions;

import distributions.math.ModeDistribution;

import expressions.Expression;

import java.math.BigDecimal;

import org.apache.commons.math3.random.RandomGenerator;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Enumerated Distribution</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link distributions.EnumeratedDistribution#getValues <em>Values</em>}</li>
 *   <li>{@link distributions.EnumeratedDistribution#getValuesExp <em>Values Exp</em>}</li>
 * </ul>
 *
 * @see distributions.DistributionsPackage#getEnumeratedDistribution()
 * @model
 * @generated
 */
public interface EnumeratedDistribution extends Distribution
{
    /**
     * Returns the value of the '<em><b>Values</b></em>' attribute list.
     * The list contents are of type {@link java.math.BigDecimal}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Values</em>' attribute list.
     * @see distributions.DistributionsPackage#getEnumeratedDistribution_Values()
     * @model unique="false" required="true" transient="true" changeable="false" volatile="true" derived="true"
     * @generated
     */
    EList<BigDecimal> getValues();

    /**
     * Returns the value of the '<em><b>Values Exp</b></em>' containment reference list.
     * The list contents are of type {@link expressions.Expression}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Values Exp</em>' containment reference list.
     * @see distributions.DistributionsPackage#getEnumeratedDistribution_ValuesExp()
     * @model containment="true" required="true"
     * @generated
     */
    EList<Expression> getValuesExp();

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @model dataType="distributions.ModeDistribution" required="true" generatorDataType="distributions.RandomGenerator"
     * @generated
     */
    ModeDistribution createModeDistribution(RandomGenerator generator);

} // EnumeratedDistribution
