/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.deployment.agent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.eclipse.kura.deployment.agent.DeploymentAgentService;
import org.eclipse.kura.deployment.agent.MarketplacePackageDescriptor;
import org.eclipse.kura.internal.rest.deployment.agent.DeploymentPackageInfo;
import org.eclipse.kura.rest.deployment.agent.api.DeploymentRequestStatus;
import org.eclipse.kura.rest.deployment.agent.api.DescriptorRequest;
import org.eclipse.kura.rest.deployment.agent.api.InstallRequest;
import org.eclipse.kura.rest.deployment.agent.api.Validable;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/deploy/v2")
public class DeploymentRestService {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentRestService.class);
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final String KURA_PERMISSION_REST_DEPLOY_ROLE = "kura.permission.rest.deploy";
    private static final String ERROR_INSTALLING_PACKAGE = "Error installing deployment package: ";
    private static final String ERROR_UNINSTALLING_PACKAGE = "Error uninstalling deployment package: ";
    private static final String BAD_REQUEST_MESSAGE = "Bad request";
    private DeploymentAdmin deploymentAdmin;
    private DeploymentAgentService deploymentAgentService;
    private UserAdmin userAdmin;

    public void setUserAdmin(UserAdmin userAdmin) {
        this.userAdmin = userAdmin;
        this.userAdmin.createRole(KURA_PERMISSION_REST_DEPLOY_ROLE, 2);
    }

    public void setDeploymentAdmin(DeploymentAdmin deploymentAdmin) {
        this.deploymentAdmin = deploymentAdmin;
    }

    public void setDeploymentAgentService(DeploymentAgentService deploymentAgentService) {
        this.deploymentAgentService = deploymentAgentService;
    }

    @GET
    @RolesAllowed(value={"deploy"})
    @Produces(value={"application/json"})
    public List<DeploymentPackageInfo> listDeploymentPackages() {
        ArrayList<DeploymentPackageInfo> deploymentPackageInfos = new ArrayList<DeploymentPackageInfo>();
        List<DeploymentPackage> deploymentPackages = Arrays.asList(this.deploymentAdmin.listDeploymentPackages());
        deploymentPackages.forEach(dp -> {
            boolean bl = deploymentPackageInfos.add(new DeploymentPackageInfo(dp.getName(), dp.getVersion().toString()));
        });
        return deploymentPackageInfos;
    }

    @PUT
    @RolesAllowed(value={"deploy"})
    @Path(value="/_packageDescriptor")
    @Produces(value={"application/json"})
    public MarketplacePackageDescriptor getMarketplacePackageDescriptor(DescriptorRequest descriptorRequest) {
        MarketplacePackageDescriptor descriptor;
        Validable.validate(descriptorRequest, BAD_REQUEST_MESSAGE);
        String url = descriptorRequest.getUrl();
        if (Objects.isNull(url) || url.isEmpty()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Missing URL parameter").build());
        }
        if (!this.isEclipseMarketplaceUrl(url)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"The URL passed as argument does not belong to the Eclipse Marketplace").build());
        }
        String[] urlStrings = url.split("=");
        if (urlStrings.length != 2 || Objects.isNull(urlStrings[1]) || urlStrings[1].isEmpty()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"The URL passed as argument does not contain a valid node id").build());
        }
        String descriptorUrl = String.format("https://marketplace.eclipse.org/node/%s/api/p", urlStrings[1]);
        try {
            descriptor = this.deploymentAgentService.getMarketplacePackageDescriptor(descriptorUrl);
        }
        catch (Exception e) {
            logger.warn("Error checking package descriptor for {}. Caused by ", (Object)url, (Object)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)("Error checking package descriptor for " + url)).build());
        }
        return descriptor;
    }

    private boolean isEclipseMarketplaceUrl(String url) {
        Pattern marketplaceUrlRegexp = Pattern.compile("https?:\\/\\/marketplace.eclipse.org/marketplace-client-intro\\?mpc_install=.*");
        return marketplaceUrlRegexp.matcher(url).matches();
    }

    @POST
    @RolesAllowed(value={"deploy"})
    @Path(value="/_install")
    @Produces(value={"application/json"})
    public DeploymentRequestStatus installDeploymentPackage(InstallRequest installRequest) {
        Validable.validate(installRequest, BAD_REQUEST_MESSAGE);
        String url = installRequest.getUrl();
        if (this.deploymentAgentService.isInstallingDeploymentPackage(url)) {
            return DeploymentRequestStatus.INSTALLING;
        }
        try {
            this.deploymentAgentService.installDeploymentPackageAsync(url);
        }
        catch (Exception exception) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)(ERROR_INSTALLING_PACKAGE + url)).build());
        }
        return DeploymentRequestStatus.REQUEST_RECEIVED;
    }

    @POST
    @RolesAllowed(value={"deploy"})
    @Path(value="/_upload")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public DeploymentRequestStatus installUploadedDeploymentPackage(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetails) {
        String uploadedFileName = fileDetails.getFileName();
        String uploadedFileLocation = String.valueOf(System.getProperty(JAVA_IO_TMPDIR)) + File.separator + UUID.randomUUID() + ".dp";
        try {
            Files.deleteIfExists(Paths.get(uploadedFileLocation, new String[0]));
        }
        catch (IOException iOException) {
            logger.warn("Cannot delete file: {}", (Object)uploadedFileLocation);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)(ERROR_INSTALLING_PACKAGE + uploadedFileName)).build());
        }
        File file = new File(uploadedFileLocation);
        try {
            if (!file.createNewFile()) {
                throw new IOException("File " + uploadedFileLocation + " was not created");
            }
            file.deleteOnExit();
        }
        catch (IOException e) {
            logger.warn("Cannot create file: {}, caused by", (Object)file, (Object)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)(ERROR_INSTALLING_PACKAGE + uploadedFileName)).build());
        }
        try {
            FileOutputStream os = new FileOutputStream(file);
            IOUtils.copy((InputStream)uploadedInputStream, (OutputStream)os);
            os.close();
        }
        catch (IOException e) {
            logger.warn("Error writing file to : {}, caused by", (Object)file.getAbsolutePath(), (Object)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)(ERROR_INSTALLING_PACKAGE + uploadedFileName)).build());
        }
        logger.info("Deployment package \"{}\" uploaded to: {}", (Object)uploadedFileName, (Object)file.getAbsolutePath());
        try {
            String fileUrl = file.toURI().toURL().toString();
            this.deploymentAgentService.installDeploymentPackageAsync(fileUrl);
        }
        catch (Exception e) {
            logger.warn("Cannot install deployment package : {}, caused by", (Object)uploadedFileName, (Object)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)(ERROR_INSTALLING_PACKAGE + uploadedFileName)).build());
        }
        return DeploymentRequestStatus.REQUEST_RECEIVED;
    }

    @DELETE
    @RolesAllowed(value={"deploy"})
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    public DeploymentRequestStatus uninstallDeploymentPackage(@PathParam(value="name") String name) {
        if (this.deploymentAgentService.isUninstallingDeploymentPackage(name)) {
            return DeploymentRequestStatus.UNINSTALLING;
        }
        try {
            this.deploymentAgentService.uninstallDeploymentPackageAsync(name);
        }
        catch (Exception exception) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)(ERROR_UNINSTALLING_PACKAGE + name)).build());
        }
        return DeploymentRequestStatus.REQUEST_RECEIVED;
    }
}

