/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultClaimCheckRepository;
import org.apache.camel.processor.ClaimCheckAggregationStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.ClaimCheckRepository;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaimCheckProcessor
extends ServiceSupport
implements AsyncProcessor,
IdAware,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(ClaimCheckProcessor.class);
    private CamelContext camelContext;
    private String id;
    private String operation;
    private AggregationStrategy aggregationStrategy;
    private String key;
    private String filter;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        ClaimCheckRepository repo = exchange.getProperty("CamelClaimCheckRepository", ClaimCheckRepository.class);
        if (repo == null) {
            repo = new DefaultClaimCheckRepository();
            exchange.setProperty("CamelClaimCheckRepository", repo);
        }
        try {
            if ("Set".equals(this.operation)) {
                Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, false);
                boolean addedNew = repo.add(this.key, copy);
                if (addedNew) {
                    LOG.debug("Add: {} -> {}", (Object)this.key, (Object)copy);
                } else {
                    LOG.debug("Override: {} -> {}", (Object)this.key, (Object)copy);
                }
            } else if ("Get".equals(this.operation)) {
                Exchange result;
                Exchange copy = repo.get(this.key);
                LOG.debug("Get: {} -> {}", (Object)this.key, (Object)exchange);
                if (copy != null && (result = this.aggregationStrategy.aggregate(exchange, copy)) != null) {
                    ExchangeHelper.copyResultsPreservePattern(exchange, result);
                }
            } else if ("GetAndRemove".equals(this.operation)) {
                Exchange copy = repo.getAndRemove(this.key);
                LOG.debug("GetAndRemove: {} -> {}", (Object)this.key, (Object)exchange);
                if (copy != null) {
                    ExchangeHelper.prepareAggregation(exchange, copy);
                    Exchange result = this.aggregationStrategy.aggregate(exchange, copy);
                    if (result != null) {
                        ExchangeHelper.copyResultsPreservePattern(exchange, result);
                    }
                }
            } else if ("Push".equals(this.operation)) {
                Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, false);
                LOG.debug("Push: {} -> {}", (Object)this.key, (Object)copy);
                repo.push(copy);
            } else if ("Pop".equals(this.operation)) {
                Exchange copy = repo.pop();
                LOG.debug("Pop: {} -> {}", (Object)this.key, (Object)exchange);
                if (copy != null) {
                    ExchangeHelper.prepareAggregation(exchange, copy);
                    Exchange result = this.aggregationStrategy.aggregate(exchange, copy);
                    if (result != null) {
                        ExchangeHelper.copyResultsPreservePattern(exchange, result);
                    }
                }
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.operation, "operation", this);
        if (this.aggregationStrategy == null) {
            this.aggregationStrategy = this.createAggregationStrategy();
        }
        if (this.aggregationStrategy instanceof CamelContextAware) {
            ((CamelContextAware)((Object)this.aggregationStrategy)).setCamelContext(this.camelContext);
        }
        ServiceHelper.startServices(this.aggregationStrategy);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.aggregationStrategy);
    }

    public String toString() {
        return "ClaimCheck[" + this.operation + "]";
    }

    protected AggregationStrategy createAggregationStrategy() {
        ClaimCheckAggregationStrategy answer = new ClaimCheckAggregationStrategy();
        answer.setFilter(this.filter);
        return answer;
    }
}

