/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.relations.options;

import java.util.List;
import java.util.Locale;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.StringOption;
import org.eclipse.escet.common.java.Strings;

public class BaseDmmOutputFileOption
extends StringOption {
    public BaseDmmOutputFileOption(String dmmKind, String defaultValue) {
        super(BaseDmmOutputFileOption.makeName(dmmKind), BaseDmmOutputFileOption.makeExplanation(dmmKind) + " " + BaseDmmOutputFileOption.makeDefaultText(defaultValue), null, BaseDmmOutputFileOption.makeLongCommand(dmmKind), "PATH", defaultValue, true, true, BaseDmmOutputFileOption.makeExplanation(dmmKind), "DMM file path:");
    }

    private static String makeName(String dmmKind) {
        return Strings.makeInitialUppercase((String)dmmKind) + " DMM output file path";
    }

    private static String makeExplanation(String dmmKind) {
        return "The path for writing the " + dmmKind + " DMM file. If the option value is left empty, a path is constructed from the path of the input CIF file, by first removing either a \".cif\" or a \".cifx\" suffix if it exists, and appending \"." + dmmKind + ".csv\". Use the text \"no\" to skip writing the file.";
    }

    private static String makeDefaultText(String defaultValue) {
        if (defaultValue == null) {
            return "The default behavior is to write the DMM file to a path derived from the CIF input file.";
        }
        if (BaseDmmOutputFileOption.skipWrite(defaultValue)) {
            return "The default behavior is to skip writing the DMM file.";
        }
        return "The default behavior is to write the DMM file to the \"" + defaultValue + "\" path.";
    }

    private static String makeLongCommand(String dmmKind) {
        return "write-" + dmmKind;
    }

    protected static String getFilePath(Class<? extends Option<String>> optionClass, String userInputPath, String dmmKind) {
        String optionValue = (String)Options.get(optionClass);
        if (optionValue == null) {
            return Paths.pathChangeSuffix((String)userInputPath, List.of(".cif", ".cifx"), (String)("." + dmmKind + ".csv"));
        }
        if (BaseDmmOutputFileOption.skipWrite(optionValue)) {
            return null;
        }
        return optionValue;
    }

    private static boolean skipWrite(String optValue) {
        return optValue.toLowerCase(Locale.US).equals("no");
    }
}

