/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.options;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.options.BooleanOption;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class HelpOption
extends BooleanOption {
    public HelpOption() {
        super("Help", "Prints the help text of the application to the console.", Character.valueOf('h'), "help", null, false, true, "Enable option to print the help text of the application to the console, and terminate the application.", "Print help message");
    }

    @Override
    public Boolean parseValue(String optName, String value) {
        AppEnv.getApplication().printHelpMessage(AppEnv.getStreams().out);
        throw new Application.SuccessfulExitException();
    }

    @Override
    public String[] getCmdLine(Object value) {
        return new String[0];
    }

    public static void printHelpHeader(String appName, String version, String description, AppStream s) {
        String msg = Strings.fmt((String)"%s (version %s)", (Object[])new Object[]{appName, version});
        HelpOption.outw(s, msg, new Object[0]);
        s.println();
        HelpOption.outw(s, description, new Object[0]);
    }

    public static void printHelpOptions(OptionCategory options, AppStream s) {
        s.println("The available command line options, per category, are:");
        s.println();
        LinkedList<OptionCategory> cats = new LinkedList<OptionCategory>();
        cats.add(options);
        List remainingArgsOpts = Lists.list();
        while (!cats.isEmpty()) {
            OptionCategory cat = (OptionCategory)cats.removeFirst();
            if (cat.getParent() != null) {
                HelpOption.outw(s, "[" + cat.getFullName() + "]", new Object[0]);
                HelpOption.outw(s, cat.getDescription(), new Object[0]);
                s.println();
            }
            for (Option<?> opt : cat.getOptions()) {
                Character cmdShort;
                if (opt.getCmdLong().equals("*")) {
                    remainingArgsOpts.add(opt);
                    continue;
                }
                String signature = "--" + opt.getCmdLong();
                String cmdValue = opt.getCmdValue();
                if (cmdValue != null) {
                    signature = signature + "=" + cmdValue;
                }
                if ((cmdShort = opt.getCmdShort()) != null) {
                    signature = signature + ", -" + String.valueOf(cmdShort);
                    if (cmdValue != null) {
                        signature = signature + " " + cmdValue;
                    }
                }
                HelpOption.outw(s, "  " + signature, new Object[0]);
                s.println(Strings.wrapEx((String)Strings.spaces((int)6), (String)Strings.spaces((int)6), (String[])new String[]{opt.getDescription()}));
                s.println();
            }
            List<OptionCategory> subcats = cat.getSubCategories();
            for (OptionCategory subcat : Lists.reverse(subcats)) {
                cats.addFirst(subcat);
            }
        }
        Assert.check((remainingArgsOpts.size() <= 1 ? 1 : 0) != 0);
        if (remainingArgsOpts.size() == 1) {
            Option opt = (Option)remainingArgsOpts.get(0);
            HelpOption.outw(s, "All other (non-option) arguments are interpreted as: " + opt.getDescription(), new Object[0]);
            s.println();
        }
        HelpOption.outw(s, "The following values can be used to enable any boolean option (BOOL): \"on\", \"true\", \"yes\", and \"1\". The corresponding values to disable are: \"off\", \"false\", \"no\", and \"0\".", new Object[0]);
    }

    public static void printHelpNotes(String[] notes, AppStream s) {
        Assert.check((notes.length > 0 ? 1 : 0) != 0);
        s.println("Notes:");
        String[] stringArray = notes;
        int n = notes.length;
        int n2 = 0;
        while (n2 < n) {
            String note = stringArray[n2];
            s.println(Strings.wrapEx((String)" - ", (String)"   ", (String[])new String[]{note}));
            ++n2;
        }
    }

    public static void printHelpExitCodes(AppStream s) {
        HelpOption.outw(s, "The application can terminate with the following exit codes:", new Object[0]);
        String[] lines = new String[]{"Application finished without errors.", "Application finished after reporting an error to the end user.", "Application crashed after running out of memory.", "Application crashed for any reason other than running out of memory."};
        Assert.check((lines.length <= 9 ? 1 : 0) != 0);
        int i = 0;
        while (i < lines.length) {
            s.println(Strings.wrapEx((String)(Strings.spaces((int)2) + i + Strings.spaces((int)2)), (String)Strings.spaces((int)5), (String[])new String[]{lines[i]}));
            ++i;
        }
    }

    public static void printHelpCopyrightEclipseEscet(AppStream s) {
        HelpOption.outw(s, "Copyright (c) 2010, 2026 Contributors to the Eclipse Foundation", new Object[0]);
        HelpOption.outw(s, "", new Object[0]);
        HelpOption.outw(s, "See the NOTICE file(s) distributed with this work for additional information regarding copyright ownership.", new Object[0]);
        HelpOption.outw(s, "", new Object[0]);
        HelpOption.outw(s, "Eclipse ESCET and ESCET are trademarks of the Eclipse Foundation. Eclipse, and the Eclipse Logo are registered trademarks of the Eclipse Foundation. Other names may be trademarks of their respective owners.", new Object[0]);
        HelpOption.outw(s, "", new Object[0]);
        HelpOption.outw(s, "This product includes software developed by other open source projects.", new Object[0]);
    }

    public static void printHelpLicenseEclipseEscet(AppStream s) {
        String licenseText;
        String resourceName = "org/eclipse/escet/common/app/framework/LICENSE.txt";
        InputStream licenseStream = HelpOption.class.getClassLoader().getResourceAsStream(resourceName);
        if (licenseStream == null) {
            licenseText = "ERROR: Could not find license file.";
        } else {
            try {
                licenseText = IOUtils.toString((InputStream)licenseStream, (String)"UTF-8");
            }
            catch (IOException e) {
                licenseText = "ERROR: Failed to read license file.";
            }
        }
        s.print(licenseText);
        s.flush();
    }

    public static void outw(AppStream s, String msg, Object ... args) {
        String[] stringArray = Strings.wrap((String[])new String[]{Strings.fmt((String)msg, (Object[])args)});
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String txt = stringArray[n2];
            s.println(txt);
            ++n2;
        }
    }
}

