/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.cif2cif.LinearizeBase;
import org.eclipse.escet.cif.cif2cif.LocationPointerManager;
import org.eclipse.escet.cif.common.CifEdgeUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.ListProductIterator;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.output.WarnOutput;

public class LinearizeProduct
extends LinearizeBase {
    private final boolean tryMergeEdges;

    public LinearizeProduct(WarnOutput warnOutput) {
        this(false, warnOutput);
    }

    public LinearizeProduct(boolean optInits, WarnOutput warnOutput) {
        this(false, optInits, warnOutput);
    }

    LinearizeProduct(boolean tryMergeEdges, boolean optInits, WarnOutput warnOutput) {
        super(optInits, warnOutput);
        this.tryMergeEdges = tryMergeEdges;
    }

    @Override
    protected void createEdges(List<Automaton> auts, Automaton mergedAut, Location mergedLoc) {
        List events = Lists.set2list((Set)CifEventUtils.getAlphabet((Automaton)mergedAut));
        List<LinearizedEdgeIterator> iterators = LinearizeProduct.linearizeEdges(auts, this.alphabets, events, this.lpIntroducer, true, false, this.tryMergeEdges);
        EList edges = mergedLoc.getEdges();
        for (Iterator iterator : iterators) {
            while (iterator.hasNext()) {
                edges.add((Edge)iterator.next());
            }
        }
    }

    public static List<LinearizedEdgeIterator> linearizeEdges(List<Automaton> auts, List<CifEventUtils.Alphabets> alphabets, List<Event> events, LocationPointerManager locPtrManager, boolean removeMonitors, boolean addLocPtrUpdates, boolean tryMergeEdges) {
        List syncAlphabets = Lists.listc((int)auts.size());
        List sendAlphabets = Lists.listc((int)auts.size());
        List recvAlphabets = Lists.listc((int)auts.size());
        List moniAlphabets = Lists.listc((int)auts.size());
        for (CifEventUtils.Alphabets autAlphabets : alphabets) {
            syncAlphabets.add(autAlphabets.syncAlphabet);
            sendAlphabets.add(autAlphabets.sendAlphabet);
            recvAlphabets.add(autAlphabets.recvAlphabet);
            moniAlphabets.add(autAlphabets.moniAlphabet);
        }
        List syncAuts = CifEventUtils.filterAutomata(auts, (List)syncAlphabets, events);
        List sendAuts = CifEventUtils.filterAutomata(auts, (List)sendAlphabets, events);
        List recvAuts = CifEventUtils.filterAutomata(auts, (List)recvAlphabets, events);
        List moniAuts = CifEventUtils.filterMonitorAuts(auts, (List)moniAlphabets, events);
        if (removeMonitors) {
            for (Automaton aut : auts) {
                aut.setMonitors(null);
            }
        }
        List iterators = Lists.listc((int)events.size());
        int i = 0;
        while (i < events.size()) {
            LinearizedEdgeIterator linearizedEdgesIter = LinearizeProduct.linearizeEdges(events.get(i), (List)syncAuts.get(i), (List)sendAuts.get(i), (List)recvAuts.get(i), (Set)moniAuts.get(i), locPtrManager, addLocPtrUpdates, tryMergeEdges);
            iterators.add(linearizedEdgesIter);
            ++i;
        }
        return iterators;
    }

    private static LinearizedEdgeIterator linearizeEdges(Event event, List<Automaton> syncAuts, List<Automaton> sendAuts, List<Automaton> recvAuts, Set<Automaton> moniAuts, LocationPointerManager locPtrManager, boolean addLocPtrUpdates, boolean tryMergeEdges) {
        boolean isChannel = event.getType() != null;
        boolean isVoid = isChannel && event.getType() instanceof VoidType;
        List autsSyncOptions = Lists.listc((int)syncAuts.size());
        for (Automaton aut : syncAuts) {
            boolean monitor = moniAuts.contains(aut);
            List autSyncOptions = Lists.list();
            List monitoredLocs = monitor ? Lists.listc((int)aut.getLocations().size()) : List.of();
            List locEdgeEvents = Lists.list();
            for (Object loc : aut.getLocations()) {
                boolean locNeedsMonitorEdge;
                boolean trueGuard = false;
                locEdgeEvents.clear();
                for (Edge edge : loc.getEdges()) {
                    for (EdgeEvent edgeEvent : edge.getEvents()) {
                        Event evt = CifEventUtils.getEventFromEdgeEvent((EdgeEvent)edgeEvent);
                        if (evt != event) continue;
                        if (edge.getGuards().isEmpty()) {
                            trueGuard = true;
                        }
                        locEdgeEvents.add(edgeEvent);
                    }
                }
                boolean bl = locNeedsMonitorEdge = monitor && !trueGuard;
                if (tryMergeEdges && locNeedsMonitorEdge && locEdgeEvents.size() == 1) {
                    EdgeEvent locEdgeEvent = (EdgeEvent)locEdgeEvents.get(0);
                    autSyncOptions.add(new MonitoredEdgeEventSyncParticipation(locEdgeEvent));
                    continue;
                }
                for (EdgeEvent locEdgeEvent : locEdgeEvents) {
                    autSyncOptions.add(new EdgeEventParticipation(locEdgeEvent));
                }
                if (!locNeedsMonitorEdge) continue;
                monitoredLocs.add(loc);
            }
            if (!monitoredLocs.isEmpty()) {
                autSyncOptions.add(new MonitoredLocsSyncParticipation(Collections.unmodifiableList(monitoredLocs), event));
            }
            if (tryMergeEdges) {
                LinearizeProduct.combineSingleOptionPerSrcLocAutSyncOptions(autSyncOptions, aut, event);
            }
            autsSyncOptions.add(autSyncOptions);
        }
        List sendOptions = Lists.list();
        for (Automaton aut : sendAuts) {
            for (Location loc : aut.getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    for (EdgeEvent edgeEvent : edge.getEvents()) {
                        Event evt = CifEventUtils.getEventFromEdgeEvent((EdgeEvent)edgeEvent);
                        if (evt != event) continue;
                        sendOptions.add(new EdgeEventParticipation(edgeEvent));
                    }
                }
            }
        }
        List recvOptions = Lists.list();
        for (Automaton aut : recvAuts) {
            for (Location loc : aut.getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    for (EdgeEvent edgeEvent : edge.getEvents()) {
                        Event evt = CifEventUtils.getEventFromEdgeEvent((EdgeEvent)edgeEvent);
                        if (evt != event) continue;
                        recvOptions.add(new EdgeEventParticipation(edgeEvent));
                    }
                }
            }
        }
        List possibilities = autsSyncOptions;
        if (isChannel) {
            possibilities.add(sendOptions);
            possibilities.add(recvOptions);
        }
        ListProductIterator combinationsIter = new ListProductIterator(possibilities);
        return new LinearizedEdgeIterator(event, isChannel, isVoid, (ListProductIterator<Participation>)combinationsIter, locPtrManager, addLocPtrUpdates);
    }

    private static void combineSingleOptionPerSrcLocAutSyncOptions(List<Participation> autSyncOptions, Automaton aut, Event event) {
        Map autSyncOptionsPerSrcLoc = Maps.mapc((int)aut.getLocations().size());
        for (Participation autSyncOption : autSyncOptions) {
            for (Location srcLoc : autSyncOption.getSourceLocations()) {
                autSyncOptionsPerSrcLoc.computeIfAbsent(srcLoc, k -> Lists.listc((int)1)).add(autSyncOption);
            }
        }
        List autSyncOptionsToCombine = Lists.set2list((Set)autSyncOptionsPerSrcLoc.entrySet().stream().map(entry -> (List)entry.getValue()).filter(ps -> ps.size() == 1).map(ps -> (Participation)Lists.single((List)ps)).collect(Collectors.toCollection(() -> Sets.set())));
        if (autSyncOptionsToCombine.size() > 1) {
            MonitoredLocsSyncParticipation monitoredLocsOption = autSyncOptionsToCombine.stream().filter(MonitoredLocsSyncParticipation.class::isInstance).map(MonitoredLocsSyncParticipation.class::cast).findAny().orElseGet(() -> null);
            if (monitoredLocsOption != null) {
                List<Location> combinedSrcLocs = autSyncOptionsPerSrcLoc.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(monitoredLocsOption)).map(entry -> (Location)entry.getKey()).toList();
                List remainingSrcLocs = Lists.copy(monitoredLocsOption.locs);
                remainingSrcLocs.removeAll(combinedSrcLocs);
                autSyncOptions.remove(monitoredLocsOption);
                if (!remainingSrcLocs.isEmpty()) {
                    autSyncOptions.add(new MonitoredLocsSyncParticipation(Collections.unmodifiableList(remainingSrcLocs), event));
                }
                autSyncOptionsToCombine.replaceAll(p -> p == monitoredLocsOption ? new MonitoredLocsSyncParticipation(Collections.unmodifiableList(combinedSrcLocs), event) : p);
            }
            autSyncOptions.removeAll(autSyncOptionsToCombine);
            autSyncOptions.add(new CombinedSyncParticipation(autSyncOptionsToCombine));
        }
    }

    private record CombinedSyncParticipation(List<Participation> subParticipations) implements Participation
    {
        public CombinedSyncParticipation {
            Assert.check((subParticipations.size() > 1 ? 1 : 0) != 0);
            Assert.check((boolean)subParticipations.stream().allMatch(p -> !(p instanceof CombinedSyncParticipation)));
            Assert.check((boolean)subParticipations.stream().flatMap(p -> p.getSourceLocations().stream()).map(Sets.set()::add).allMatch(b -> b));
        }

        @Override
        public List<Location> getSourceLocations() {
            return this.subParticipations.stream().flatMap(sub -> sub.getSourceLocations().stream()).toList();
        }
    }

    private record EdgeEventParticipation(EdgeEvent edgeEvent) implements Participation
    {
        @Override
        public List<Location> getSourceLocations() {
            Edge edge = (Edge)this.edgeEvent.eContainer();
            Location src = CifEdgeUtils.getSource((Edge)edge);
            return List.of(src);
        }
    }

    public static class LinearizedEdgeIterator
    implements Iterator<Edge> {
        private final Event event;
        private final boolean isChannel;
        private final boolean isVoid;
        private final ListProductIterator<Participation> combinationsIter;
        private final LocationPointerManager locPtrManager;
        private final boolean addLocPtrUpdates;

        private LinearizedEdgeIterator(Event event, boolean isChannel, boolean isVoid, ListProductIterator<Participation> combinationsIter, LocationPointerManager locPtrManager, boolean addLocPtrUpdates) {
            this.event = event;
            this.isChannel = isChannel;
            this.isVoid = isVoid;
            this.combinationsIter = combinationsIter;
            this.locPtrManager = locPtrManager;
            this.addLocPtrUpdates = addLocPtrUpdates;
        }

        public Optional<Long> getResultSize() {
            return this.combinationsIter.getResultSize();
        }

        @Override
        public boolean hasNext() {
            return this.combinationsIter.hasNext();
        }

        @Override
        public Edge next() {
            List participations = this.combinationsIter.next();
            List guards = Lists.listc((int)(2 * participations.size()));
            for (Participation participation : participations) {
                LinearizedEdgeIterator.addGuards(participation, guards, this.locPtrManager);
            }
            Expression guard = CifValueUtils.createConjunction((List)guards);
            List updates = Lists.list();
            List<Update> rcvUpdates = Lists.list();
            int i = 0;
            while (i < participations.size()) {
                Participation participation = (Participation)participations.get(i);
                if (this.isChannel && !this.isVoid && i == participations.size() - 1) {
                    LinearizedEdgeIterator.addUpdates(participation, rcvUpdates, this.locPtrManager, this.addLocPtrUpdates);
                } else {
                    LinearizedEdgeIterator.addUpdates(participation, updates, this.locPtrManager, this.addLocPtrUpdates);
                }
                ++i;
            }
            if (this.isChannel && !this.isVoid) {
                int sendIdx = participations.size() - 2;
                Participation sendParticipation = (Participation)participations.get(sendIdx);
                EdgeEvent sendEdgeEvent = ((EdgeEventParticipation)sendParticipation).edgeEvent;
                Expression sendValue = ((EdgeSend)sendEdgeEvent).getValue();
                rcvUpdates = LinearizeProduct.replaceUpdates(rcvUpdates, sendValue);
                updates.addAll(rcvUpdates);
            }
            EventExpression eventRef = CifConstructors.newEventExpression();
            eventRef.setEvent(this.event);
            eventRef.setType((CifType)CifConstructors.newBoolType());
            EdgeEvent edgeEvent = CifConstructors.newEdgeEvent();
            edgeEvent.setEvent((Expression)eventRef);
            Edge edge = CifConstructors.newEdge();
            edge.getEvents().add((Object)edgeEvent);
            edge.getGuards().add((Object)guard);
            edge.getUpdates().addAll((Collection)updates);
            return edge;
        }

        private static void addGuards(Participation participation, List<Expression> guards, LocationPointerManager locPtrManager) {
            if (participation instanceof EdgeEventParticipation) {
                EdgeEventParticipation eeParticipation = (EdgeEventParticipation)participation;
                EdgeEvent edgeEvent = eeParticipation.edgeEvent;
                Edge edge = (Edge)edgeEvent.eContainer();
                Location src = CifEdgeUtils.getSource((Edge)edge);
                Automaton aut = (Automaton)src.eContainer();
                if (aut.getLocations().size() > 1) {
                    Expression srcRef = locPtrManager.createLocRef(src);
                    guards.add(srcRef);
                }
                guards.addAll(EMFHelper.deepclone((List)edge.getGuards()));
            } else if (participation instanceof MonitoredEdgeEventSyncParticipation) {
                MonitoredEdgeEventSyncParticipation meesParticipation = (MonitoredEdgeEventSyncParticipation)participation;
                EdgeEvent edgeEvent = meesParticipation.edgeEvent;
                Edge edge = (Edge)edgeEvent.eContainer();
                Location src = CifEdgeUtils.getSource((Edge)edge);
                Automaton aut = (Automaton)src.eContainer();
                if (aut.getLocations().size() > 1) {
                    Expression srcRef = locPtrManager.createLocRef(src);
                    guards.add(srcRef);
                }
            } else if (participation instanceof MonitoredLocsSyncParticipation) {
                MonitoredLocsSyncParticipation mlsParticipation = (MonitoredLocsSyncParticipation)participation;
                List<Location> srcLocs = mlsParticipation.locs;
                Event event = mlsParticipation.monitoredEvent;
                List locsGuards = Lists.listc((int)srcLocs.size());
                for (Location srcLoc : srcLocs) {
                    List locGuards = Lists.listc((int)4);
                    Automaton aut = CifLocationUtils.getAutomaton((Location)srcLoc);
                    if (aut.getLocations().size() > 1) {
                        Expression srcRef = locPtrManager.createLocRef(srcLoc);
                        locGuards.add(srcRef);
                    }
                    for (Edge srcEdge : srcLoc.getEdges()) {
                        for (EdgeEvent srcEdgeEvent : srcEdge.getEvents()) {
                            Event evt = CifEventUtils.getEventFromEdgeEvent((EdgeEvent)srcEdgeEvent);
                            if (evt != event) continue;
                            List edgeGuards = EMFHelper.deepclone((List)srcEdge.getGuards());
                            Expression edgeGuard = CifValueUtils.createConjunction((List)edgeGuards);
                            locGuards.add(CifValueUtils.makeInverse((Expression)edgeGuard));
                        }
                    }
                    locsGuards.add(CifValueUtils.createConjunction((List)locGuards));
                }
                guards.add(CifValueUtils.createDisjunction((List)locsGuards));
            } else if (participation instanceof CombinedSyncParticipation) {
                CombinedSyncParticipation csParticipation = (CombinedSyncParticipation)participation;
                List subsGuards = Lists.listc((int)csParticipation.subParticipations.size());
                for (Participation subParticipation : csParticipation.subParticipations) {
                    List subGuards = Lists.listc((int)1);
                    LinearizedEdgeIterator.addGuards(subParticipation, subGuards, locPtrManager);
                    subsGuards.add(CifValueUtils.createConjunction((List)subGuards));
                }
                guards.add(CifValueUtils.createDisjunction((List)subsGuards));
            } else {
                throw new AssertionError((Object)("Unknown participation: " + String.valueOf(participation)));
            }
        }

        private static void addUpdates(Participation participation, List<Update> updates, LocationPointerManager locPtrManager, boolean addLocPtrUpdate) {
            if (participation instanceof EdgeEventParticipation) {
                Location tgtLoc;
                Location srcLoc;
                EdgeEventParticipation eeParticipation = (EdgeEventParticipation)participation;
                EdgeEvent edgeEvent = eeParticipation.edgeEvent;
                Edge edge = (Edge)edgeEvent.eContainer();
                updates.addAll(EMFHelper.deepclone((List)edge.getUpdates()));
                if (addLocPtrUpdate && (srcLoc = CifEdgeUtils.getSource((Edge)edge)) != (tgtLoc = CifEdgeUtils.getTarget((Edge)edge))) {
                    updates.add(locPtrManager.createLocUpdate(tgtLoc));
                }
            } else if (participation instanceof MonitoredEdgeEventSyncParticipation) {
                boolean needsLocPtrUpdate;
                MonitoredEdgeEventSyncParticipation meesParticipation = (MonitoredEdgeEventSyncParticipation)participation;
                EdgeEvent edgeEvent = meesParticipation.edgeEvent;
                Edge edge = (Edge)edgeEvent.eContainer();
                Location srcLoc = CifEdgeUtils.getSource((Edge)edge);
                Location tgtLoc = CifEdgeUtils.getTarget((Edge)edge);
                boolean bl = needsLocPtrUpdate = addLocPtrUpdate && srcLoc != tgtLoc;
                if (needsLocPtrUpdate || !edge.getUpdates().isEmpty()) {
                    IfUpdate ifUpd = CifConstructors.newIfUpdate();
                    updates.add((Update)ifUpd);
                    ifUpd.getGuards().addAll((Collection)EMFHelper.deepclone((List)edge.getGuards()));
                    ifUpd.getThens().addAll((Collection)EMFHelper.deepclone((List)edge.getUpdates()));
                    if (needsLocPtrUpdate) {
                        ifUpd.getThens().add((Object)locPtrManager.createLocUpdate(tgtLoc));
                    }
                }
            } else if (!(participation instanceof MonitoredLocsSyncParticipation)) {
                if (participation instanceof CombinedSyncParticipation) {
                    CombinedSyncParticipation csParticipation = (CombinedSyncParticipation)participation;
                    IfUpdate ifUpd = CifConstructors.newIfUpdate();
                    for (Participation subParticipation : csParticipation.subParticipations) {
                        IfUpdate subIfUpd;
                        Update update;
                        List subUpdates = Lists.list();
                        LinearizedEdgeIterator.addUpdates(subParticipation, subUpdates, locPtrManager, addLocPtrUpdate);
                        if (subUpdates.isEmpty()) continue;
                        List<Expression> srcLocRefs = subParticipation.getSourceLocations().stream().map(locPtrManager::createLocRef).toList();
                        Expression guard = CifValueUtils.createDisjunction(srcLocRefs);
                        if (subUpdates.size() == 1 && (update = (Update)subUpdates.get(0)) instanceof IfUpdate && (subIfUpd = (IfUpdate)update).getElifs().isEmpty() && subIfUpd.getElses().isEmpty()) {
                            guard = CifValueUtils.createConjunction(List.of(guard, CifValueUtils.createConjunction((List)subIfUpd.getGuards())));
                            subUpdates = subIfUpd.getThens();
                        }
                        if (ifUpd.getGuards().isEmpty()) {
                            ifUpd.getGuards().add((Object)guard);
                            ifUpd.getThens().addAll((Collection)subUpdates);
                            continue;
                        }
                        ifUpd.getElifs().add((Object)CifConstructors.newElifUpdate(List.of(guard), null, (List)subUpdates));
                    }
                    if (!ifUpd.getGuards().isEmpty()) {
                        updates.add((Update)ifUpd);
                    }
                } else {
                    throw new AssertionError((Object)("Unknown participation: " + String.valueOf(participation)));
                }
            }
        }
    }

    private record MonitoredEdgeEventSyncParticipation(EdgeEvent edgeEvent) implements Participation
    {
        @Override
        public List<Location> getSourceLocations() {
            Edge edge = (Edge)this.edgeEvent.eContainer();
            Location src = CifEdgeUtils.getSource((Edge)edge);
            return List.of(src);
        }
    }

    private record MonitoredLocsSyncParticipation(List<Location> locs, Event monitoredEvent) implements Participation
    {
        public MonitoredLocsSyncParticipation {
            Assert.check((!locs.isEmpty() ? 1 : 0) != 0);
        }

        @Override
        public List<Location> getSourceLocations() {
            return this.locs;
        }
    }

    private static interface Participation {
        public List<Location> getSourceLocations();
    }
}

