/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.model;

import com.sun.webui.jsf.model.FileChooserItem;
import com.sun.webui.jsf.model.ResourceItem;
import com.sun.webui.jsf.model.ResourceModel;
import com.sun.webui.jsf.model.ResourceModelException;
import com.sun.webui.jsf.util.FilterUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.context.FacesContext;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.Collator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;

public final class FileChooserModel
implements ResourceModel,
Serializable {
    private static final long serialVersionUID = 7437797148169351743L;
    private static final String WINDOWS_OS = "window";
    private static final String SPACE = "&nbsp;";
    private static final String WINDOWS_ROOT = "c:\\";
    private static final String UNIX_ROOT = "/";
    private static final String DEFAULT_SERVER = "localhost";
    private String root = null;
    private String separatorString = File.separator;
    private String currentDir = null;
    private String filterValue = "*";
    private String sortValue = null;
    private boolean folderChooser = false;
    private boolean typeSet = false;
    private String serverName = null;
    private transient Collator collator = null;

    public FileChooserModel() {
        this.root = this.isWindows() ? WINDOWS_ROOT : UNIX_ROOT;
        try {
            this.serverName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ukhe) {
            this.serverName = DEFAULT_SERVER;
        }
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name").toUpperCase();
        return osName.startsWith(WINDOWS_OS.toUpperCase());
    }

    @Override
    public String getAbsoluteRoot() {
        return this.root;
    }

    @Override
    public String[] getRoots() {
        File[] roots = File.listRoots();
        int len = roots.length;
        boolean isWindows = this.isWindows();
        if (isWindows) {
            ++len;
        }
        String[] strRoots = new String[len];
        for (int i = 0; i < roots.length; ++i) {
            strRoots[i] = roots[i].getPath();
        }
        if (isWindows) {
            strRoots[len] = File.separator;
        }
        return strRoots;
    }

    @Override
    public void setAbsoluteRoot(String absRoot) {
        if (absRoot != null) {
            this.root = absRoot;
        }
    }

    @Override
    public String getSeparatorString() {
        return this.separatorString;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setServerName(String newServerName) {
        if (newServerName != null) {
            this.serverName = newServerName;
        }
    }

    @Override
    public String getFilterValue() {
        return this.filterValue;
    }

    @Override
    public void setFilterValue(String newFilterValue) {
        if (newFilterValue != null) {
            this.validateFilterValue(newFilterValue);
            this.filterValue = newFilterValue;
        }
    }

    @Override
    public String getSortValue() {
        return this.sortValue;
    }

    @Override
    public void setSortValue(String newSortValue) {
        if (newSortValue != null) {
            this.validateSortValue(newSortValue);
            this.sortValue = newSortValue;
        }
    }

    @Override
    public String getCurrentDir() {
        if (this.currentDir != null) {
            return this.currentDir;
        }
        return this.getAbsoluteRoot();
    }

    @Override
    public void setCurrentDir(String dir) throws ResourceModelException {
        if (dir != null && dir.length() > 0) {
            this.validateFolder(dir);
            this.currentDir = dir;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ResourceItem[] getFolderContent(String folder, boolean disableFiles, boolean disableFolders) {
        int count;
        FacesContext context = FacesContext.getCurrentInstance();
        ArrayList<FileChooserItem> optList = new ArrayList<FileChooserItem>();
        FilterUtil filter = new FilterUtil(this.getFilterValue());
        boolean filesExist = false;
        String zFolder = folder == null ? this.getCurrentDir() : folder;
        if (zFolder == null) {
            return null;
        }
        File file = new File(zFolder);
        File[] fileList = file.listFiles();
        if (fileList == null || fileList.length == 0) {
            return null;
        }
        ArrayList<File> justFiles = new ArrayList<File>();
        ArrayList<File> justDirs = new ArrayList<File>();
        for (File file2 : fileList) {
            if (file2.isDirectory()) {
                justDirs.add(file2);
                continue;
            }
            justFiles.add(file2);
        }
        File[] fileArray = new File[justFiles.size()];
        for (int i = 0; i < justFiles.size(); ++i) {
            fileArray[i] = (File)justFiles.get(i);
        }
        File[] dirArray = new File[justDirs.size()];
        for (int i = 0; i < justDirs.size(); ++i) {
            dirArray[i] = (File)justDirs.get(i);
        }
        this.sort(fileArray, this.getSortValue());
        this.sort(dirArray, this.getSortValue());
        for (count = 0; count < justDirs.size(); ++count) {
            fileList[count] = dirArray[count];
        }
        System.arraycopy(fileArray, 0, fileList, count, justFiles.size());
        for (File fileList1 : fileList) {
            String name = fileList1.getName();
            boolean bSelectable = false;
            boolean bIsDirectory = fileList1.isDirectory();
            boolean disabled = false;
            if (!bIsDirectory) {
                if (!filter.accept(fileList1)) continue;
                bSelectable = true;
                if (disableFiles) {
                    disabled = true;
                }
            } else {
                bSelectable = true;
            }
            FileChooserItem item = FileChooserModel.getItem(fileList1, context, disabled);
            optList.add(item);
            filesExist = true;
        }
        if (filesExist) {
            void var17_20;
            ResourceItem[] fileEntries = new FileChooserItem[optList.size()];
            boolean bl = false;
            while (var17_20 < optList.size()) {
                fileEntries[var17_20] = (FileChooserItem)optList.get((int)var17_20);
                ++var17_20;
            }
            return fileEntries;
        }
        return null;
    }

    @Override
    public ResourceItem getResourceItem(String itemKey) {
        FacesContext context = FacesContext.getCurrentInstance();
        String[] strArray = itemKey.split("=");
        if (strArray == null) {
            return null;
        }
        String resource = strArray.length == 2 ? strArray[1] : strArray[0];
        File f = new File(resource);
        return FileChooserModel.getItem(f, context, false);
    }

    @Override
    public boolean isFolderType(String path) {
        File f = new File(path);
        return f.isDirectory();
    }

    @Override
    public boolean canRead(String resourceName) {
        File f = new File(resourceName);
        return f.canRead();
    }

    @Override
    public boolean canWrite(String resourceName) {
        File f = new File(resourceName);
        return f.canWrite();
    }

    private static FileChooserItem getItem(File file, FacesContext context, boolean disabled) {
        String value;
        Theme theme = ThemeUtilities.getTheme(context);
        int fileNameLen = Integer.parseInt(theme.getMessage("filechooser.fileNameLen"));
        int fileSizeLen = Integer.parseInt(theme.getMessage("filechooser.fileSizeLen"));
        int fileDateLen = Integer.parseInt(theme.getMessage("filechooser.fileDateLen"));
        Locale locale = context.getViewRoot().getLocale();
        DateFormat dateFormat = SimpleDateFormat.getDateInstance(3, locale);
        String defaultPattern = ((SimpleDateFormat)dateFormat).toLocalizedPattern();
        if (!defaultPattern.contains("yyyy")) {
            defaultPattern = defaultPattern.replaceFirst("yy", "yyyy");
        }
        if (!defaultPattern.contains("MM")) {
            defaultPattern = defaultPattern.replaceFirst("M", "MM");
        }
        if (!defaultPattern.contains("dd")) {
            defaultPattern = defaultPattern.replaceFirst("d", "dd");
        }
        try {
            defaultPattern = ThemeUtilities.getTheme(context).getMessage("filechooser.".concat(defaultPattern));
        }
        catch (MissingResourceException mre) {
            defaultPattern = "MM/dd/yyyy";
        }
        ((SimpleDateFormat)dateFormat).applyPattern(defaultPattern);
        SimpleDateFormat timeFormat = new SimpleDateFormat(theme.getMessage("filechooser.timeFormat"), locale);
        Object name = file.getName();
        if (file.isDirectory()) {
            name = (String)name + File.separator;
            value = "folder=" + file.getAbsolutePath();
        } else {
            value = "file=" + file.getAbsolutePath();
        }
        name = FileChooserModel.getDisplayString((String)name, fileNameLen);
        String size = Long.toString(file.length());
        size = FileChooserModel.getDisplayString(size, fileSizeLen);
        Date modifiedDate = new Date(file.lastModified());
        String date = dateFormat.format(modifiedDate);
        String time = timeFormat.format(modifiedDate);
        StringBuilder buffer = new StringBuilder();
        buffer.append((String)name).append(SPACE).append(SPACE).append(SPACE).append(size).append(SPACE).append(SPACE).append(date).append(SPACE).append(time);
        FileChooserItem item = new FileChooserItem(file);
        item.setItemKey(value);
        item.setItemLabel(buffer.toString());
        item.setItemDisabled(disabled);
        return item;
    }

    private static String getDisplayString(String str, int maxLen) {
        Object res = str;
        int length = ((String)res).length();
        if (length < maxLen) {
            int spaceCount = maxLen - length;
            for (int j = 0; j < spaceCount; ++j) {
                res = (String)res + SPACE;
            }
        } else if (length > maxLen) {
            int shownLen = maxLen - 3;
            res = ((String)res).substring(0, shownLen);
            res = (String)res + "...";
        }
        return res;
    }

    private void sort(File[] fileList, String newSortValue) {
        if (fileList == null || fileList.length == 0) {
            return;
        }
        if (fileList.length == 1) {
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Locale locale = context.getViewRoot().getLocale();
        this.collator = Collator.getInstance(locale);
        this.collator.setStrength(1);
        String zSortValue = newSortValue;
        if (zSortValue == null) {
            zSortValue = "alphabetica";
        }
        SortRule sr = null;
        if (zSortValue.equals("alphabetica")) {
            sr = new SortRule(){

                @Override
                public boolean compare(File file1, File file2) {
                    return FileChooserModel.this.collator.compare(file1.getName(), file2.getName()) >= 0;
                }
            };
        } else if (zSortValue.equals("alphabeticd")) {
            sr = new SortRule(){

                @Override
                public boolean compare(File file1, File file2) {
                    return FileChooserModel.this.collator.compare(file2.getName(), file1.getName()) >= 0;
                }
            };
        } else if (zSortValue.equals("sizea")) {
            sr = new SortRule(){

                @Override
                public boolean compare(File file1, File file2) {
                    if (file1.length() == file2.length()) {
                        return FileChooserModel.this.collator.compare(file1.getName(), file2.getName()) >= 0;
                    }
                    return file1.length() > file2.length();
                }
            };
        } else if (zSortValue.equals("sized")) {
            sr = new SortRule(){

                @Override
                public boolean compare(File file1, File file2) {
                    if (file1.length() == file2.length()) {
                        return FileChooserModel.this.collator.compare(file1.getName(), file2.getName()) >= 0;
                    }
                    return file1.length() < file2.length();
                }
            };
        } else if (zSortValue.equals("timea")) {
            sr = new SortRule(){

                @Override
                public boolean compare(File file1, File file2) {
                    if (file1.lastModified() == file2.lastModified()) {
                        return FileChooserModel.this.collator.compare(file1.getName(), file2.getName()) >= 0;
                    }
                    return file1.lastModified() > file2.lastModified();
                }
            };
        } else if (zSortValue.equals("timed")) {
            sr = new SortRule(){

                @Override
                public boolean compare(File file1, File file2) {
                    if (file1.lastModified() == file2.lastModified()) {
                        return FileChooserModel.this.collator.compare(file1.getName(), file2.getName()) >= 0;
                    }
                    return file1.lastModified() < file2.lastModified();
                }
            };
        }
        for (int i = fileList.length - 1; i >= 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (!sr.compare(fileList[j], fileList[j + 1])) continue;
                File tmp = fileList[j];
                fileList[j] = fileList[j + 1];
                fileList[j + 1] = tmp;
            }
        }
    }

    @Override
    public String getParentFolder() {
        String parentDir = null;
        try {
            File parent = new File(this.getCurrentDir());
            parentDir = parent.getParent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parentDir;
    }

    @Override
    public String getEscapeChar() {
        if (this.getSeparatorString().equals(UNIX_ROOT)) {
            return "\\";
        }
        return UNIX_ROOT;
    }

    @Override
    public String getDelimiterChar() {
        return ",";
    }

    private void validateFolder(String folder) throws ResourceModelException {
        if (!this.canRead(folder)) {
            throw new ResourceModelException(FileChooserModel.createFacesMessage("filechooser.cannotCompleteErrSum", "filechooser.cannot_read_folder", null, new String[]{folder}));
        }
    }

    private void validateSortValue(String newSortValue) throws ResourceModelException {
    }

    private void validateFilterValue(String newFilterValue) throws ResourceModelException {
    }

    @Override
    public Object[] getSelectedContent(String[] content, boolean selectFolders) throws ResourceModelException {
        File parent = null;
        try {
            parent = new File(this.getCurrentDir());
        }
        catch (Exception e) {
            String detail = selectFolders ? "filechooser.folderSelectError" : "filechooser.fileSelectError";
            FileChooserModel.throwException(e, "filechooser.cannotCompleteErrSum", detail, null, null);
        }
        if (selectFolders) {
            return FileChooserModel.getSelectedFolders(parent, content);
        }
        return this.getSelectedFiles(parent, content);
    }

    private static File[] getSelectedFolders(File parent, String[] folders) throws ResourceModelException {
        ArrayList<File> folderArray = new ArrayList<File>();
        for (int i = 0; i < folders.length; ++i) {
            try {
                File folder = new File(folders[i]);
                if (!folder.isAbsolute()) {
                    folder = new File(parent, folders[i]);
                }
                if (!folder.canRead()) {
                    throw new ResourceModelException(FileChooserModel.createFacesMessage("filechooser.cannotCompleteErrSum", "filechooser.cannot_read_selected_folder", null, new String[]{folders[i]}));
                }
                if (!folder.isDirectory()) {
                    throw new ResourceModelException(FileChooserModel.createFacesMessage("filechooser.cannotCompleteErrSum", "filechooser.cannotSelectFile", null, null));
                }
                folderArray.add(folder);
                continue;
            }
            catch (ResourceModelException fcme) {
                throw fcme;
            }
            catch (Exception e) {
                FileChooserModel.throwException(e, "filechooser.cannotCompleteErrSum", "filechooser.fileSelectError", null, null);
            }
        }
        return folderArray.toArray(new File[0]);
    }

    private File[] getSelectedFiles(File parent, String[] files) {
        String newCurrentDir = null;
        ArrayList<File> filesArray = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            try {
                File file = new File(files[i]);
                if (!file.isAbsolute()) {
                    file = new File(parent, files[i]);
                } else if (newCurrentDir == null) {
                    newCurrentDir = file.getParent();
                }
                if (!file.canRead()) {
                    throw new ResourceModelException(FileChooserModel.createFacesMessage("filechooser.cannotCompleteErrSum", "filechooser.cannot_read_selected_file", null, new String[]{files[i]}));
                }
                if (file.isDirectory()) {
                    newCurrentDir = null;
                    if (files.length == 1) {
                        this.setCurrentDir(file.getPath());
                        break;
                    }
                    throw new ResourceModelException(FileChooserModel.createFacesMessage("filechooser.cannotCompleteErrSum", "filechooser.cannotSelectFolder", null, null));
                }
                filesArray.add(file);
                continue;
            }
            catch (ResourceModelException fcme) {
                throw fcme;
            }
            catch (Exception e) {
                FileChooserModel.throwException(e, "filechooser.cannotCompleteErrSum", "filechooser.folderSelectError", null, null);
            }
        }
        if (newCurrentDir != null) {
            this.setCurrentDir(newCurrentDir);
        }
        return filesArray.toArray(new File[0]);
    }

    private static void throwException(Exception e, String summary, String detail, String[] summaryArgs, String[] detailArgs) throws ResourceModelException {
        FacesMessage fmsg = FileChooserModel.createFacesMessage(summary, detail, summaryArgs, detailArgs);
        Throwable cause = e.getCause();
        if (cause != null) {
            throw new ResourceModelException(fmsg, cause);
        }
        throw new ResourceModelException(fmsg);
    }

    private static FacesMessage createFacesMessage(String summary, String detail, String[] summaryArgs, String[] detailArgs) {
        FacesContext context = FacesContext.getCurrentInstance();
        Theme theme = ThemeUtilities.getTheme(context);
        String summaryMsg = theme.getMessage(summary, summaryArgs);
        String detailMsg = theme.getMessage(detail, detailArgs);
        FacesMessage fmsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, summaryMsg, detailMsg);
        return fmsg;
    }

    private static interface SortRule {
        public boolean compare(File var1, File var2);
    }
}

