/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.derby.iapi.jdbc.EngineLOB;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.AutoPositioningStream;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.impl.jdbc.PositionedStoreStream;
import org.apache.derby.impl.jdbc.UpdatableBlobStream;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.error.StandardException;

final class EmbedBlob
extends ConnectionChild
implements Blob,
EngineLOB {
    private boolean materialized;
    private PositionedStoreStream myStream;
    private int locator = 0;
    private long streamLength = -1L;
    private final int streamPositionOffset;
    private boolean isValid = true;
    private LOBStreamControl control;

    EmbedBlob(byte[] byArray, EmbedConnection embedConnection) throws SQLException {
        super(embedConnection);
        try {
            this.control = new LOBStreamControl(embedConnection, byArray);
            this.materialized = true;
            this.streamPositionOffset = Integer.MIN_VALUE;
            embedConnection.addLOBReference(this);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    protected EmbedBlob(DataValueDescriptor dataValueDescriptor, EmbedConnection embedConnection) throws StandardException, SQLException {
        super(embedConnection);
        if (dataValueDescriptor.hasStream()) {
            this.streamPositionOffset = this.handleStreamValue(dataValueDescriptor.getStream(), embedConnection);
        } else {
            this.materialized = true;
            this.streamPositionOffset = Integer.MIN_VALUE;
            byte[] byArray = dataValueDescriptor.getBytes();
            try {
                this.control = new LOBStreamControl(this.getEmbedConnection(), byArray);
            }
            catch (IOException iOException) {
                throw Util.setStreamFailure(iOException);
            }
        }
        embedConnection.addLOBReference(this);
    }

    private int handleStreamValue(InputStream inputStream, EmbedConnection embedConnection) throws StandardException, SQLException {
        int n = 0;
        if (inputStream instanceof Resetable) {
            this.materialized = false;
            try {
                this.myStream = new PositionedStoreStream(inputStream);
                BinaryToRawStream binaryToRawStream = new BinaryToRawStream(this.myStream, embedConnection);
                n = (int)this.myStream.getPosition();
                this.streamLength = binaryToRawStream.getLength();
                binaryToRawStream.close();
            }
            catch (StandardException standardException) {
                if (standardException.getMessageId().equals("40XD0")) {
                    throw StandardException.newException("XJ073.S", new Object[0]);
                }
                throw standardException;
            }
            catch (IOException iOException) {
                throw StandardException.newException("XCL30.S", iOException, "BLOB");
            }
        }
        this.materialized = true;
        n = Integer.MIN_VALUE;
        try {
            int n2;
            this.control = new LOBStreamControl(this.getEmbedConnection());
            BinaryToRawStream binaryToRawStream = new BinaryToRawStream(inputStream, embedConnection);
            byte[] byArray = new byte[4096];
            long l = 0L;
            while ((n2 = binaryToRawStream.read(byArray, 0, byArray.length)) >= 1) {
                l = this.control.write(byArray, 0, n2, l);
            }
            binaryToRawStream.close();
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        return n;
    }

    private long setBlobPosition(long l) throws StandardException, IOException {
        if (this.materialized) {
            if (l >= this.control.getLength()) {
                throw StandardException.newException("XJ076.S", l);
            }
        } else {
            try {
                this.myStream.reposition(l + (long)this.streamPositionOffset);
            }
            catch (EOFException eOFException) {
                throw StandardException.newException("XJ076.S", eOFException, l);
            }
        }
        return l;
    }

    private int read(long l) throws IOException, StandardException {
        int n;
        if (this.materialized) {
            if (l >= this.control.getLength()) {
                return -1;
            }
            n = this.control.read(l);
        } else {
            this.myStream.reposition(l + (long)this.streamPositionOffset);
            n = this.myStream.read();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws SQLException {
        this.checkValidity();
        try {
            if (this.materialized) {
                return this.control.getLength();
            }
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        if (this.streamLength != -1L) {
            return this.streamLength;
        }
        boolean bl = false;
        try {
            Object object = this.getConnectionSynchronization();
            synchronized (object) {
                try {
                    EmbedConnection embedConnection = this.getEmbedConnection();
                    boolean bl2 = bl = !embedConnection.isClosed();
                    if (bl) {
                        this.setupContextStack();
                    }
                    this.myStream.resetStream();
                    BinaryToRawStream binaryToRawStream = new BinaryToRawStream(this.myStream, this);
                    this.streamLength = InputStreamUtil.skipUntilEOF(binaryToRawStream);
                    binaryToRawStream.close();
                    EmbedBlob.restoreIntrFlagIfSeen(bl, embedConnection);
                    long l = this.streamLength;
                    return l;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throw this.handleMyExceptions(throwable2);
                    }
                }
            }
        }
        finally {
            if (bl) {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        this.checkValidity();
        boolean bl = false;
        try {
            byte[] byArray;
            if (l < 1L) {
                throw StandardException.newException("XJ070.S", l);
            }
            if (n < 0) {
                throw StandardException.newException("XJ071.S", n);
            }
            if (this.materialized) {
                byArray = new byte[n];
                int n2 = this.control.read(byArray, 0, byArray.length, l - 1L);
                if (n2 == -1) {
                    InterruptStatus.restoreIntrFlagIfSeen();
                    byte[] byArray2 = new byte[]{};
                    return byArray2;
                }
                if (n2 < n) {
                    byte[] byArray3 = new byte[n2];
                    System.arraycopy(byArray, 0, byArray3, 0, n2);
                    byArray = byArray3;
                }
                InterruptStatus.restoreIntrFlagIfSeen();
            } else {
                Object object = this.getConnectionSynchronization();
                synchronized (object) {
                    EmbedConnection embedConnection;
                    block21: {
                        embedConnection = this.getEmbedConnection();
                        boolean bl2 = bl = !embedConnection.isClosed();
                        if (bl) {
                            this.setupContextStack();
                        }
                        this.setBlobPosition(l - 1L);
                        byArray = new byte[n];
                        int n3 = InputStreamUtil.readLoop(this.myStream, byArray, 0, n);
                        if (n3 >= n) break block21;
                        byte[] byArray4 = new byte[n3];
                        System.arraycopy(byArray, 0, byArray4, 0, n3);
                        EmbedBlob.restoreIntrFlagIfSeen(bl, embedConnection);
                        byte[] byArray5 = byArray4;
                        return byArray5;
                    }
                    EmbedBlob.restoreIntrFlagIfSeen(bl, embedConnection);
                }
            }
            byte[] byArray6 = byArray;
            return byArray6;
        }
        catch (StandardException standardException) {
            StandardException standardException2;
            if (standardException.getMessageId().equals("XJ079.S")) {
                standardException2 = StandardException.newException("XJ076.S", l);
            }
            throw this.handleMyExceptions(standardException2);
        }
        catch (Throwable throwable) {
            throw this.handleMyExceptions(throwable);
        }
        finally {
            if (bl) {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkValidity();
        boolean bl = false;
        try {
            if (this.materialized) {
                InputStream inputStream;
                InputStream inputStream2 = inputStream = this.control.getInputStream(0L);
                return inputStream2;
            }
            Object object = this.getConnectionSynchronization();
            synchronized (object) {
                try {
                    EmbedConnection embedConnection = this.getEmbedConnection();
                    boolean bl2 = bl = !embedConnection.isClosed();
                    if (bl) {
                        this.setupContextStack();
                    }
                    this.myStream.resetStream();
                    UpdatableBlobStream updatableBlobStream = new UpdatableBlobStream(this, new AutoPositioningStream(this, this.myStream, this));
                    EmbedBlob.restoreIntrFlagIfSeen(bl, embedConnection);
                    UpdatableBlobStream updatableBlobStream2 = updatableBlobStream;
                    return updatableBlobStream2;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throw this.handleMyExceptions(throwable2);
                    }
                }
            }
        }
        finally {
            if (bl) {
                this.restoreContextStack();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long position(byte[] var1_1, long var2_2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkMatch(byte[] byArray, long l) throws IOException, StandardException {
        for (int i = 1; i < byArray.length; ++i) {
            int n;
            if ((n = this.read(l++)) >= 0 && n == byArray[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long position(Blob var1_1, long var2_2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 14[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkMatch(Blob blob, long l) throws IOException, StandardException {
        int n;
        InputStream inputStream;
        try {
            inputStream = blob.getBinaryStream();
        }
        catch (SQLException sQLException) {
            return false;
        }
        if (inputStream == null) {
            return false;
        }
        int n2 = inputStream.read();
        if (n2 < 0) {
            return false;
        }
        do {
            if ((n2 = inputStream.read()) >= 0) continue;
            return true;
        } while (n2 == (n = this.read(l++)) && n >= 0);
        return false;
    }

    private SQLException handleMyExceptions(Throwable throwable) throws SQLException {
        if (throwable instanceof StandardException && ((StandardException)throwable).getMessageId().equals("40XD0")) {
            throwable = StandardException.newException("XJ073.S", new Object[0]);
        }
        return this.handleException(throwable);
    }

    protected void finalize() {
        if (!this.materialized) {
            this.myStream.closeStream();
        }
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        this.checkValidity();
        if (l - 1L > this.length()) {
            throw Util.generateCsSQLException("XJ076.S", l);
        }
        if (l < 1L) {
            throw Util.generateCsSQLException("XJ070.S", l);
        }
        if (n < 0 || n > byArray.length) {
            throw Util.generateCsSQLException("XJ078.S", n);
        }
        if (n2 < 0) {
            throw Util.generateCsSQLException("XJ071.S", n2);
        }
        if (n2 == 0) {
            return 0;
        }
        if (n2 > byArray.length - n) {
            throw Util.generateCsSQLException("XJ079.S", n2);
        }
        try {
            if (this.materialized) {
                this.control.write(byArray, n, n2, l - 1L);
            } else {
                this.control = new LOBStreamControl(this.getEmbedConnection());
                this.control.copyData(this.myStream, this.length());
                this.control.write(byArray, n, n2, l - 1L);
                this.myStream.close();
                this.streamLength = -1L;
                this.materialized = true;
            }
            return n2;
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        this.checkValidity();
        if (l - 1L > this.length()) {
            throw Util.generateCsSQLException("XJ076.S", l);
        }
        if (l < 1L) {
            throw Util.generateCsSQLException("XJ070.S", l);
        }
        try {
            if (this.materialized) {
                return this.control.getOutputStream(l - 1L);
            }
            this.control = new LOBStreamControl(this.getEmbedConnection());
            this.control.copyData(this.myStream, l - 1L);
            this.myStream.close();
            this.streamLength = -1L;
            this.materialized = true;
            return this.control.getOutputStream(l - 1L);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    @Override
    public void truncate(long l) throws SQLException {
        if (l > this.length()) {
            throw Util.generateCsSQLException("XJ079.S", l);
        }
        try {
            if (this.materialized) {
                this.control.truncate(l);
            } else {
                this.setBlobPosition(0L);
                this.control = new LOBStreamControl(this.getEmbedConnection());
                this.control.copyData(this.myStream, l);
                this.myStream.close();
                this.streamLength = -1L;
                this.materialized = true;
            }
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    @Override
    public void free() throws SQLException {
        if (!this.isValid) {
            return;
        }
        this.isValid = false;
        if (this.locator != 0) {
            this.localConn.removeLOBMapping(this.locator);
        }
        this.streamLength = -1L;
        if (!this.materialized) {
            this.myStream.closeStream();
            this.myStream = null;
        } else {
            try {
                this.control.free();
                this.control = null;
            }
            catch (IOException iOException) {
                throw Util.setStreamFailure(iOException);
            }
        }
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        this.checkValidity();
        if (l <= 0L) {
            throw Util.generateCsSQLException("XJ070.S", l);
        }
        if (l2 < 0L) {
            throw Util.generateCsSQLException("XJ071.S", l2);
        }
        if (l2 > this.length() - (l - 1L)) {
            throw Util.generateCsSQLException("XJ087.S", l, l2);
        }
        try {
            return new UpdatableBlobStream(this, this.getBinaryStream(), l - 1L, l2);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
    }

    private void checkValidity() throws SQLException {
        this.getEmbedConnection().checkIfClosed();
        if (!this.isValid) {
            throw EmbedBlob.newSQLException("XJ215.S", new Object[0]);
        }
    }

    boolean isMaterialized() {
        return this.materialized;
    }

    @Override
    public int getLocator() {
        if (this.locator == 0) {
            this.locator = this.localConn.addLOBMapping(this);
        }
        return this.locator;
    }
}

