/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jnosql.util;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.configurator.BeanConfigurator;
import java.lang.reflect.Type;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class CdiExtensionUtil {
    public static final int INTEGRATION_BEANS_PRIORITY = 4000;

    private CdiExtensionUtil() {
    }

    public static <T> BeanConfigurator<T> addBean(Class<T> beanClass, AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        return afterBeanDiscovery.addBean().types(new Type[]{beanClass}).createWith(CdiExtensionUtil.createBeanProducer(beanClass, beanManager)).destroyWith(CdiExtensionUtil.createBeanDestroyer(beanClass, beanManager));
    }

    public static <BEAN_TYPE> BiConsumer<BEAN_TYPE, CreationalContext<BEAN_TYPE>> createBeanDestroyer(Class<BEAN_TYPE> beanType, BeanManager beanManager) {
        return (instance, ctx) -> {
            AnnotatedType annotatedType = beanManager.createAnnotatedType(beanType);
            InjectionTarget injectionTarget = beanManager.getInjectionTargetFactory(annotatedType).createInjectionTarget(null);
            injectionTarget.preDestroy(instance);
            injectionTarget.dispose(instance);
        };
    }

    public static <BEAN_TYPE> Function<CreationalContext<BEAN_TYPE>, BEAN_TYPE> createBeanProducer(Class<BEAN_TYPE> beanType, BeanManager beanManager) {
        return ctx -> {
            AnnotatedType annotatedType = beanManager.createAnnotatedType(beanType);
            InjectionTarget injectionTarget = beanManager.getInjectionTargetFactory(annotatedType).createInjectionTarget(null);
            Object instance = injectionTarget.produce(ctx);
            injectionTarget.inject(instance, ctx);
            injectionTarget.postConstruct(instance);
            return instance;
        };
    }
}

