/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.ProcessingState;

class HttpResponsePacketImpl
extends HttpResponsePacket {
    private static final ThreadCache.CachedTypeIndex<HttpResponsePacketImpl> CACHE_IDX = ThreadCache.obtainIndex(HttpResponsePacketImpl.class, 16);

    public static HttpResponsePacketImpl create() {
        HttpResponsePacketImpl httpResponseImpl = ThreadCache.takeFromCache(CACHE_IDX);
        if (httpResponseImpl != null) {
            return httpResponseImpl;
        }
        return new HttpResponsePacketImpl(){

            @Override
            public void recycle() {
                super.recycle();
                ThreadCache.putToCache(CACHE_IDX, this);
            }
        };
    }

    protected HttpResponsePacketImpl() {
    }

    @Override
    public ProcessingState getProcessingState() {
        return this.getRequest().getProcessingState();
    }

    @Override
    protected void reset() {
        super.reset();
    }

    @Override
    public void recycle() {
        HttpRequestPacket localRequest = this.getRequest();
        if (localRequest != null && localRequest.isExpectContent()) {
            return;
        }
        this.reset();
    }
}

