/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.cdi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionTarget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.internal.sessions.cdi.InjectionManager;

public class InjectionManagerImpl<T>
implements InjectionManager<T> {
    protected BeanManager beanManager = null;
    protected CreationalContext<T> creationalContext = null;
    protected final Map<T, InjectionTarget<T>> injectionTargets = new HashMap<T, InjectionTarget<T>>();

    public InjectionManagerImpl(Object beanManagerInstance) throws NamingException {
        if (beanManagerInstance == null) {
            InitialContext context = new InitialContext();
            try {
                beanManagerInstance = context.lookup("java:comp/BeanManager");
            }
            catch (NamingException e) {
                beanManagerInstance = context.lookup("java:comp/env/BeanManager");
            }
        }
        this.beanManager = (BeanManager)beanManagerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T createManagedBeanAndInjectDependencies(Class<T> managedBeanClass) throws NamingException {
        AnnotatedType aType = this.beanManager.createAnnotatedType(managedBeanClass);
        InjectionTarget injectionTarget = this.beanManager.getInjectionTargetFactory(aType).createInjectionTarget(null);
        this.creationalContext = this.beanManager.createCreationalContext(null);
        Object beanInstance = injectionTarget.produce(this.creationalContext);
        Map<T, InjectionTarget<T>> map = this.injectionTargets;
        synchronized (map) {
            this.injectionTargets.put(beanInstance, injectionTarget);
        }
        injectionTarget.inject(beanInstance, this.creationalContext);
        injectionTarget.postConstruct(beanInstance);
        return (T)beanInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        HashSet<T> keys = new HashSet<T>();
        try {
            Map<T, InjectionTarget<T>> map = this.injectionTargets;
            synchronized (map) {
                keys.addAll(this.injectionTargets.keySet());
                for (Object listener : keys) {
                    InjectionTarget<T> target = this.injectionTargets.get(listener);
                    target.preDestroy(listener);
                    target.dispose(listener);
                    this.injectionTargets.remove(listener);
                }
            }
        }
        finally {
            if (this.creationalContext != null) {
                this.creationalContext.release();
            }
        }
    }
}

