/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import com.sun.logging.LogCleanerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Logger;
import org.apache.catalina.Server;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.ResourceParams;
import org.apache.naming.ContextAccessController;
import org.apache.naming.ContextBindings;
import org.apache.naming.EjbRef;
import org.apache.naming.NamingContext;
import org.apache.naming.ResourceEnvRef;
import org.apache.naming.ResourceLinkRef;
import org.apache.naming.ResourceRef;
import org.apache.naming.TransactionRef;
import org.apache.naming.factory.ResourceLinkFactory;

public class NamingContextListener
implements LifecycleListener,
ContainerListener,
PropertyChangeListener {
    private static final java.util.logging.Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    protected String name = "/";
    protected Object container = null;
    protected int debug = 0;
    protected boolean initialized = false;
    protected NamingResources namingResources = null;
    protected NamingContext namingContext = null;
    protected javax.naming.Context compCtx = null;
    protected javax.naming.Context envCtx = null;

    public NamingContextListener() {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "new NamingContextListener");
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "setName " + name);
        }
    }

    public NamingContext getNamingContext() {
        return this.namingContext;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        this.container = event.getLifecycle();
        if (this.container instanceof Context) {
            this.namingResources = ((Context)this.container).getNamingResources();
        } else if (this.container instanceof Server) {
            this.namingResources = ((Server)this.container).getGlobalNamingResources();
        } else {
            return;
        }
        if ("start".equals(event.getType())) {
            String msg;
            if (this.initialized) {
                return;
            }
            Hashtable contextEnv = new Hashtable();
            try {
                this.namingContext = new NamingContext(contextEnv, this.getName());
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            ContextAccessController.setSecurityToken((Object)this.getName(), (Object)this.container);
            ContextBindings.bindContext((Object)this.container, (javax.naming.Context)this.namingContext, (Object)this.container);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Bound " + String.valueOf(this.container));
            }
            ContextAccessController.setWritable((Object)this.getName(), (Object)this.container);
            try {
                this.createNamingContext();
            }
            catch (NamingException e) {
                msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00120"), e);
                this.log(msg);
            }
            this.namingResources.addPropertyChangeListener(this);
            if (this.container instanceof Context) {
                ContextAccessController.setReadOnly((Object)this.getName());
                try {
                    ContextBindings.bindClassLoader((Object)this.container, (Object)this.container, (ClassLoader)((Container)this.container).getLoader().getClassLoader());
                }
                catch (NamingException e) {
                    msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00121"), e);
                    this.log(msg);
                }
            }
            if (this.container instanceof Server) {
                ResourceLinkFactory.setGlobalContext((javax.naming.Context)this.namingContext);
                try {
                    ContextBindings.bindClassLoader((Object)this.container, (Object)this.container, (ClassLoader)this.getClass().getClassLoader());
                }
                catch (NamingException e) {
                    msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00121"), e);
                    this.log(msg);
                }
                if (this.container instanceof StandardServer) {
                    ((StandardServer)this.container).setGlobalNamingContext((javax.naming.Context)this.namingContext);
                }
            }
            this.initialized = true;
        } else if ("stop".equals(event.getType())) {
            if (!this.initialized) {
                return;
            }
            ContextAccessController.setWritable((Object)this.getName(), (Object)this.container);
            ContextBindings.unbindContext((Object)this.container, (Object)this.container);
            if (this.container instanceof Context) {
                ContextBindings.unbindClassLoader((Object)this.container, (Object)this.container, (ClassLoader)((Container)this.container).getLoader().getClassLoader());
            }
            if (this.container instanceof Server) {
                this.namingResources.removePropertyChangeListener(this);
                ContextBindings.unbindClassLoader((Object)this.container, (Object)this.container, (ClassLoader)this.getClass().getClassLoader());
            }
            ContextAccessController.unsetSecurityToken((Object)this.getName(), (Object)this.container);
            this.namingContext = null;
            this.envCtx = null;
            this.compCtx = null;
            this.initialized = false;
        }
    }

    @Override
    public void containerEvent(ContainerEvent event) {
        String resourceEnvRefName;
        if (!this.initialized) {
            return;
        }
        ContextAccessController.setWritable((Object)this.getName(), (Object)this.container);
        String type = event.getType();
        if (type.equals("addEjb")) {
            String ejbName = (String)event.getData();
            if (ejbName != null) {
                ContextEjb ejb = this.namingResources.findEjb(ejbName);
                this.addEjb(ejb);
            }
        } else if (type.equals("addEnvironment")) {
            String environmentName = (String)event.getData();
            if (environmentName != null) {
                ContextEnvironment env = this.namingResources.findEnvironment(environmentName);
                this.addEnvironment(env);
            }
        } else if (type.equals("addResourceParams") || type.equals("removeResourceParams")) {
            String resourceParamsName = (String)event.getData();
            if (resourceParamsName != null) {
                ContextResourceLink resourceLink;
                String resourceEnvRefValue;
                ContextResource resource;
                ContextEjb ejb = this.namingResources.findEjb(resourceParamsName);
                if (ejb != null) {
                    this.removeEjb(resourceParamsName);
                    this.addEjb(ejb);
                }
                if ((resource = this.namingResources.findResource(resourceParamsName)) != null) {
                    this.removeResource(resourceParamsName);
                    this.addResource(resource);
                }
                if ((resourceEnvRefValue = this.namingResources.findResourceEnvRef(resourceParamsName)) != null) {
                    this.removeResourceEnvRef(resourceParamsName);
                    this.addResourceEnvRef(resourceParamsName, resourceEnvRefValue);
                }
                if ((resourceLink = this.namingResources.findResourceLink(resourceParamsName)) != null) {
                    this.removeResourceLink(resourceParamsName);
                    this.addResourceLink(resourceLink);
                }
            }
        } else if (type.equals("addLocalEjb")) {
            String localEjbName = (String)event.getData();
            if (localEjbName != null) {
                ContextLocalEjb localEjb = this.namingResources.findLocalEjb(localEjbName);
                this.addLocalEjb(localEjb);
            }
        } else if (type.equals("addResource")) {
            String resourceName = (String)event.getData();
            if (resourceName != null) {
                ContextResource resource = this.namingResources.findResource(resourceName);
                this.addResource(resource);
            }
        } else if (type.equals("addResourceLink")) {
            String resourceLinkName = (String)event.getData();
            if (resourceLinkName != null) {
                ContextResourceLink resourceLink = this.namingResources.findResourceLink(resourceLinkName);
                this.addResourceLink(resourceLink);
            }
        } else if (type.equals("addResourceEnvRef")) {
            String resourceEnvRefName2 = (String)event.getData();
            if (resourceEnvRefName2 != null) {
                String resourceEnvRefValue = this.namingResources.findResourceEnvRef(resourceEnvRefName2);
                this.addResourceEnvRef(resourceEnvRefName2, resourceEnvRefValue);
            }
        } else if (type.equals("removeEjb")) {
            String ejbName = (String)event.getData();
            if (ejbName != null) {
                this.removeEjb(ejbName);
            }
        } else if (type.equals("removeEnvironment")) {
            String environmentName = (String)event.getData();
            if (environmentName != null) {
                this.removeEnvironment(environmentName);
            }
        } else if (type.equals("removeLocalEjb")) {
            String localEjbName = (String)event.getData();
            if (localEjbName != null) {
                this.removeLocalEjb(localEjbName);
            }
        } else if (type.equals("removeResource")) {
            String resourceName = (String)event.getData();
            if (resourceName != null) {
                this.removeResource(resourceName);
            }
        } else if (type.equals("removeResourceLink")) {
            String resourceLinkName = (String)event.getData();
            if (resourceLinkName != null) {
                this.removeResourceLink(resourceLinkName);
            }
        } else if (type.equals("removeResourceEnvRef") && (resourceEnvRefName = (String)event.getData()) != null) {
            this.removeResourceEnvRef(resourceEnvRefName);
        }
        ContextAccessController.setReadOnly((Object)this.getName());
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!this.initialized) {
            return;
        }
        Object source = event.getSource();
        if (source == this.namingResources) {
            ContextAccessController.setWritable((Object)this.getName(), (Object)this.container);
            this.processGlobalResourcesChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
            ContextAccessController.setReadOnly((Object)this.getName());
        }
    }

    private void processGlobalResourcesChange(String name, Object oldValue, Object newValue) {
        if (name.equals("ejb")) {
            ContextEjb ejb;
            if (oldValue != null && (ejb = (ContextEjb)oldValue).getName() != null) {
                this.removeEjb(ejb.getName());
            }
            if (newValue != null && (ejb = (ContextEjb)newValue).getName() != null) {
                this.addEjb(ejb);
            }
        } else if (name.equals("environment")) {
            ContextEnvironment env;
            if (oldValue != null && (env = (ContextEnvironment)oldValue).getName() != null) {
                this.removeEnvironment(env.getName());
            }
            if (newValue != null && (env = (ContextEnvironment)newValue).getName() != null) {
                this.addEnvironment(env);
            }
        } else if (name.equals("localEjb")) {
            ContextLocalEjb ejb;
            if (oldValue != null && (ejb = (ContextLocalEjb)oldValue).getName() != null) {
                this.removeLocalEjb(ejb.getName());
            }
            if (newValue != null && (ejb = (ContextLocalEjb)newValue).getName() != null) {
                this.addLocalEjb(ejb);
            }
        } else if (name.equals("resource")) {
            ContextResource resource;
            if (oldValue != null && (resource = (ContextResource)oldValue).getName() != null) {
                this.removeResource(resource.getName());
            }
            if (newValue != null && (resource = (ContextResource)newValue).getName() != null) {
                this.addResource(resource);
            }
        } else if (name.equals("resourceEnvRef")) {
            int colon;
            String update;
            if (oldValue != null) {
                update = (String)oldValue;
                colon = update.indexOf(58);
                this.removeResourceEnvRef(update.substring(0, colon));
            }
            if (newValue != null) {
                update = (String)newValue;
                colon = update.indexOf(58);
                this.addResourceEnvRef(update.substring(0, colon), update.substring(colon + 1));
            }
        } else if (name.equals("resourceLink")) {
            ContextResourceLink rl;
            if (oldValue != null && (rl = (ContextResourceLink)oldValue).getName() != null) {
                this.removeResourceLink(rl.getName());
            }
            if (newValue != null && (rl = (ContextResourceLink)newValue).getName() != null) {
                this.addResourceLink(rl);
            }
        } else if (name.equals("resourceParams")) {
            String resourceParamsName = null;
            ResourceParams rp = null;
            if (oldValue != null) {
                rp = (ResourceParams)oldValue;
            }
            if (newValue != null) {
                rp = (ResourceParams)newValue;
            }
            if (rp != null) {
                resourceParamsName = rp.getName();
            }
            if (resourceParamsName != null) {
                ContextResourceLink resourceLink;
                String resourceEnvRefValue;
                ContextResource resource;
                ContextEjb ejb = this.namingResources.findEjb(resourceParamsName);
                if (ejb != null) {
                    this.removeEjb(resourceParamsName);
                    this.addEjb(ejb);
                }
                if ((resource = this.namingResources.findResource(resourceParamsName)) != null) {
                    this.removeResource(resourceParamsName);
                    this.addResource(resource);
                }
                if ((resourceEnvRefValue = this.namingResources.findResourceEnvRef(resourceParamsName)) != null) {
                    this.removeResourceEnvRef(resourceParamsName);
                    this.addResourceEnvRef(resourceParamsName, resourceEnvRefValue);
                }
                if ((resourceLink = this.namingResources.findResourceLink(resourceParamsName)) != null) {
                    this.removeResourceLink(resourceParamsName);
                    this.addResourceLink(resourceLink);
                }
            }
        }
    }

    private void createNamingContext() throws NamingException {
        String msg;
        int i;
        if (this.container instanceof Server) {
            this.compCtx = this.namingContext;
            this.envCtx = this.namingContext;
        } else {
            this.compCtx = this.namingContext.createSubcontext("comp");
            this.envCtx = this.compCtx.createSubcontext("env");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating JNDI naming context");
        }
        if (this.namingResources == null) {
            this.namingResources = new NamingResources();
            this.namingResources.setContainer(this.container);
        }
        ContextResourceLink[] resourceLinks = this.namingResources.findResourceLinks();
        for (i = 0; i < resourceLinks.length; ++i) {
            this.addResourceLink(resourceLinks[i]);
        }
        ContextResource[] resources = this.namingResources.findResources();
        for (i = 0; i < resources.length; ++i) {
            this.addResource(resources[i]);
        }
        String[] resourceEnvRefs = this.namingResources.findResourceEnvRefs();
        for (i = 0; i < resourceEnvRefs.length; ++i) {
            String key = resourceEnvRefs[i];
            String type = this.namingResources.findResourceEnvRef(key);
            this.addResourceEnvRef(key, type);
        }
        ContextEnvironment[] contextEnvironments = this.namingResources.findEnvironments();
        for (i = 0; i < contextEnvironments.length; ++i) {
            this.addEnvironment(contextEnvironments[i]);
        }
        ContextEjb[] ejbs = this.namingResources.findEjbs();
        for (i = 0; i < ejbs.length; ++i) {
            this.addEjb(ejbs[i]);
        }
        if (this.container instanceof Context) {
            try {
                TransactionRef ref = new TransactionRef();
                this.compCtx.bind("UserTransaction", (Object)ref);
                this.addAdditionalParameters(this.namingResources, (Reference)ref, "UserTransaction");
            }
            catch (NamingException e) {
                msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00121"), e);
                this.log(msg);
            }
        }
        if (this.container instanceof Context) {
            try {
                this.compCtx.bind("Resources", (Object)((Container)this.container).getResources());
            }
            catch (NamingException e) {
                msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00121"), e);
                this.log(msg);
            }
        }
    }

    public void addEjb(ContextEjb ejb) {
        EjbRef ref = new EjbRef(ejb.getType(), ejb.getHome(), ejb.getRemote(), ejb.getLink());
        this.addAdditionalParameters(ejb.getNamingResources(), (Reference)ref, ejb.getName());
        try {
            this.createSubcontexts(this.envCtx, ejb.getName());
            this.envCtx.bind(ejb.getName(), (Object)ref);
        }
        catch (NamingException e) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00121"), e);
            this.log(msg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addEnvironment(ContextEnvironment env) {
        String msg;
        Object value = null;
        String type = env.getType();
        try {
            if (type.equals("java.lang.String")) {
                value = env.getValue();
            } else if (type.equals("java.lang.Byte")) {
                value = env.getValue() == null ? Byte.valueOf((byte)0) : Byte.decode(env.getValue());
            } else if (type.equals("java.lang.Short")) {
                value = env.getValue() == null ? Short.valueOf((short)0) : Short.decode(env.getValue());
            } else if (type.equals("java.lang.Integer")) {
                value = env.getValue() == null ? Integer.valueOf(0) : Integer.decode(env.getValue());
            } else if (type.equals("java.lang.Long")) {
                value = env.getValue() == null ? Long.valueOf(0L) : Long.decode(env.getValue());
            } else if (type.equals("java.lang.Boolean")) {
                value = Boolean.valueOf(env.getValue());
            } else if (type.equals("java.lang.Double")) {
                value = env.getValue() == null ? Double.valueOf(0.0) : Double.valueOf(env.getValue());
            } else if (type.equals("java.lang.Float")) {
                value = env.getValue() == null ? Float.valueOf(0.0f) : Float.valueOf(env.getValue());
            } else if (type.equals("java.lang.Character")) {
                if (env.getValue() == null) {
                    value = Character.valueOf('\u0000');
                } else {
                    if (env.getValue().length() != 1) throw new IllegalArgumentException();
                    value = Character.valueOf(env.getValue().charAt(0));
                }
            } else {
                String msg2 = MessageFormat.format(rb.getString("AS-WEB-CORE-00122"), env.getName());
                this.log(msg2);
            }
        }
        catch (NumberFormatException e) {
            msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00123"), env.getName());
            this.log(msg);
        }
        catch (IllegalArgumentException e) {
            msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00123"), env.getName());
            this.log(msg);
        }
        if (value == null) return;
        try {
            if (this.debug >= 2) {
                this.log("  Adding environment entry " + env.getName());
            }
            this.createSubcontexts(this.envCtx, env.getName());
            this.envCtx.bind(env.getName(), value);
            return;
        }
        catch (NamingException e) {
            msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00123"), env.getName());
            this.log(msg);
        }
    }

    public void addLocalEjb(ContextLocalEjb localEjb) {
    }

    public void addResource(ContextResource resource) {
        ResourceRef ref = new ResourceRef(resource.getType(), resource.getDescription(), resource.getScope(), resource.getAuth());
        this.addAdditionalParameters(resource.getNamingResources(), (Reference)ref, resource.getName());
        try {
            if (this.debug >= 2) {
                this.log("  Adding resource ref " + resource.getName());
                this.log("  " + String.valueOf(ref));
            }
            this.createSubcontexts(this.envCtx, resource.getName());
            this.envCtx.bind(resource.getName(), (Object)ref);
        }
        catch (NamingException e) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00121"), e);
            this.log(msg);
        }
    }

    public void addResourceEnvRef(String name, String type) {
        ResourceEnvRef ref = new ResourceEnvRef(type);
        this.addAdditionalParameters(null, (Reference)ref, name);
        try {
            if (this.debug >= 2) {
                this.log("  Adding resource env ref " + name);
            }
            this.createSubcontexts(this.envCtx, name);
            this.envCtx.bind(name, (Object)ref);
        }
        catch (NamingException e) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00121"), e);
            this.log(msg);
        }
    }

    public void addResourceLink(ContextResourceLink resourceLink) {
        ResourceLinkRef ref = new ResourceLinkRef(resourceLink.getType(), resourceLink.getGlobal());
        this.addAdditionalParameters(resourceLink.getNamingResources(), (Reference)ref, resourceLink.getName());
        try {
            if (this.debug >= 2) {
                this.log("  Adding resource link " + resourceLink.getName());
            }
            this.createSubcontexts(this.envCtx, resourceLink.getName());
            this.envCtx.bind(resourceLink.getName(), (Object)ref);
        }
        catch (NamingException e) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00121"), e);
            this.log(msg);
        }
    }

    public void removeEjb(String name) {
        try {
            this.envCtx.unbind(name);
        }
        catch (NamingException e) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00121"), e);
            this.log(msg);
        }
    }

    public void removeEnvironment(String name) {
        try {
            this.envCtx.unbind(name);
        }
        catch (NamingException e) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00121"), e);
            this.log(msg);
        }
    }

    public void removeLocalEjb(String name) {
        try {
            this.envCtx.unbind(name);
        }
        catch (NamingException e) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00121"), e);
            this.log(msg);
        }
    }

    public void removeResource(String name) {
        try {
            this.envCtx.unbind(name);
        }
        catch (NamingException e) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00121"), e);
            this.log(msg);
        }
    }

    public void removeResourceEnvRef(String name) {
        try {
            this.envCtx.unbind(name);
        }
        catch (NamingException e) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00121"), e);
            this.log(msg);
        }
    }

    public void removeResourceLink(String name) {
        try {
            this.envCtx.unbind(name);
        }
        catch (NamingException e) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00121"), e);
            this.log(msg);
        }
    }

    private void createSubcontexts(javax.naming.Context ctx, String name) throws NamingException {
        javax.naming.Context currentContext = ctx;
        StringTokenizer tokenizer = new StringTokenizer(name, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("") || !tokenizer.hasMoreTokens()) continue;
            try {
                currentContext = currentContext.createSubcontext(token);
            }
            catch (NamingException e) {
                currentContext = (javax.naming.Context)currentContext.lookup(token);
            }
        }
    }

    private void addAdditionalParameters(NamingResources resources, Reference ref, String name) {
        if (resources == null) {
            resources = this.namingResources;
        }
        ResourceParams resourceParameters = resources.findResourceParams(name);
        if (this.debug >= 2) {
            this.log("  Resource parameters for " + name + " = " + String.valueOf(resourceParameters));
        }
        if (resourceParameters == null) {
            return;
        }
        Hashtable<String, String> params = resourceParameters.getParameters();
        Enumeration<String> enumeration = params.keys();
        while (enumeration.hasMoreElements()) {
            String paramName = enumeration.nextElement();
            String paramValue = params.get(paramName);
            StringRefAddr refAddr = new StringRefAddr(paramName, paramValue);
            ref.add(refAddr);
        }
    }

    protected void log(String message) {
        message = LogCleanerUtil.neutralizeForLog((String)message);
        if (!(this.container instanceof Container)) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, this.logName() + ": " + message);
            }
            return;
        }
        Logger logger = ((Container)this.container).getLogger();
        if (logger != null) {
            logger.log(this.logName() + ": " + message);
        } else if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, this.logName() + ": " + message);
        }
    }

    protected void log(String message, Throwable t) {
        message = LogCleanerUtil.neutralizeForLog((String)message);
        if (!(this.container instanceof Container)) {
            log.log(Level.WARNING, this.logName() + ": " + message, t);
            return;
        }
        Logger logger = ((Container)this.container).getLogger();
        if (logger != null) {
            logger.log(this.logName() + ": " + message, t, 2);
        } else {
            log.log(Level.WARNING, this.logName() + ": " + message, t);
        }
    }

    protected String logName() {
        String className = this.getClass().getName();
        int period = className.lastIndexOf(".");
        if (period >= 0) {
            className = className.substring(period + 1);
        }
        return className + "[" + this.getName() + "]";
    }
}

