/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Configuration;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import org.glassfish.jersey.client.internal.HttpUrlConnector;
import org.glassfish.jersey.client.internal.HttpUrlConnectorConfiguration;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.client.spi.ConnectorProvider;

public class HttpUrlConnectorProvider
implements ConnectorProvider {
    public static final String USE_FIXED_LENGTH_STREAMING = "jersey.config.client.httpUrlConnector.useFixedLengthStreaming";
    public static final String SET_METHOD_WORKAROUND = "jersey.config.client.httpUrlConnection.setMethodWorkaround";
    protected final Config config;

    public HttpUrlConnectorProvider() {
        this.config = new Config();
    }

    private HttpUrlConnectorProvider(Config config) {
        this.config = config;
    }

    public static Config config() {
        return new Config();
    }

    public HttpUrlConnectorProvider connectionFactory(ConnectionFactory connectionFactory) {
        this.config.connectionFactory(connectionFactory);
        return this;
    }

    public HttpUrlConnectorProvider chunkSize(int chunkSize) {
        this.config.chunkSize(chunkSize);
        return this;
    }

    public HttpUrlConnectorProvider useFixedLengthStreaming() {
        this.config.useFixedLengthStreaming(true);
        return this;
    }

    public HttpUrlConnectorProvider useSetMethodWorkaround() {
        this.config.useSetMethodWorkaround(true);
        return this;
    }

    @Override
    public Connector getConnector(Client client, Configuration configuration) {
        this.config.preInit(configuration);
        return this.createHttpUrlConnector(client, this.config.connectionFactory(), this.config.chunkSize(), this.config.fixLengthStreaming(), this.config.setMethodWorkaround());
    }

    protected Connector createHttpUrlConnector(Client client, ConnectionFactory connectionFactory, int chunkSize, boolean fixLengthStreaming, boolean setMethodWorkaround) {
        return new HttpUrlConnector(client, client.getConfiguration(), this.config);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpUrlConnectorProvider that = (HttpUrlConnectorProvider)o;
        return this.config.equals(that.config);
    }

    public int hashCode() {
        return this.config.hashCode();
    }

    public static final class Config
    extends HttpUrlConnectorConfiguration<Config> {
        public HttpUrlConnectorProvider build() {
            return new HttpUrlConnectorProvider(this);
        }

        ConnectionFactory connectionFactory() {
            return (ConnectionFactory)this.connectionFactory.get();
        }

        int chunkSize() {
            return (Integer)this.chunkSize.get();
        }

        boolean fixLengthStreaming() {
            return (Boolean)this.useFixedLengthStreaming.get();
        }

        boolean setMethodWorkaround() {
            return (Boolean)this.useSetMethodWorkaround.get();
        }

        void preInit(Configuration configuration) {
            super.preInit(configuration.getProperties());
        }
    }

    public static interface ConnectionFactory {
        public HttpURLConnection getConnection(URL var1) throws IOException;

        default public HttpURLConnection getConnection(URL url, Proxy proxy) throws IOException {
            return proxy == null ? this.getConnection(url) : (HttpURLConnection)url.openConnection(proxy);
        }
    }
}

