/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.helper;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.login.AppConfigurationEntry;
import org.glassfish.epicyro.config.helper.ModulesManager;
import org.glassfish.epicyro.config.jaas.ExtendedConfigFile;

public class JAASModulesManager
extends ModulesManager {
    private static final System.Logger LOG = System.getLogger(JAASModulesManager.class.getName());
    private static final String DEFAULT_ENTRY_NAME = "other";
    private static final Class<?>[] PARAMS = new Class[0];
    private static final Object[] ARGS = new Object[0];
    private final ExtendedConfigFile jaasConfig;
    private final String appContext;
    private final ReentrantReadWriteLock instanceReadWriteLock = new ReentrantReadWriteLock();
    private final Lock instanceWriteLock = this.instanceReadWriteLock.writeLock();
    private AppConfigurationEntry[] appConfigurationEntry;
    private Constructor<?>[] loginModuleConstructors;

    public JAASModulesManager(boolean returnNullContexts, ExtendedConfigFile jaasConfig, Map<String, ?> properties, String appContext) throws AuthException {
        super(returnNullContexts);
        this.jaasConfig = jaasConfig;
        this.appContext = appContext;
        this.initialize();
    }

    @Override
    public Map<String, Object> getInitProperties(int i, Map<String, ?> properties) {
        HashMap<String, Object> initProperties = new HashMap<String, Object>();
        if (this.appConfigurationEntry[i] != null) {
            Map<String, ?> options;
            if (properties != null && !properties.isEmpty()) {
                initProperties.putAll(properties);
            }
            if ((options = this.appConfigurationEntry[i].getOptions()) != null && !options.isEmpty()) {
                initProperties.putAll(options);
            }
        }
        return initProperties;
    }

    @Override
    public final void refresh() {
        this.jaasConfig.refresh();
        this.initialize();
    }

    @Override
    public <M> boolean hasModules(M[] template, String authContextID) throws AuthException {
        this.loadConstructors(template, authContextID);
        for (Constructor<?> constructor : this.loginModuleConstructors) {
            if (constructor == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public <M> M[] getModules(M[] template, String authContextID) throws AuthException {
        this.loadConstructors(template, authContextID);
        ArrayList moduleInstances = new ArrayList(this.loginModuleConstructors.length);
        for (int moduleNumber = 0; moduleNumber < this.loginModuleConstructors.length; ++moduleNumber) {
            if (this.loginModuleConstructors[moduleNumber] == null) {
                moduleInstances.add(moduleNumber, null);
                continue;
            }
            int j = moduleNumber;
            try {
                moduleInstances.add(j, this.loginModuleConstructors[j].newInstance(ARGS));
                continue;
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                throw (AuthException)new AuthException().initCause(e.getCause());
            }
        }
        return moduleInstances.toArray(template);
    }

    @Override
    public boolean shouldStopProcessingModules(AuthStatus[] successValue, int moduleNumber, AuthStatus moduleStatus) {
        if (this.appConfigurationEntry[moduleNumber] != null && this.loginModuleConstructors[moduleNumber] != null) {
            AppConfigurationEntry.LoginModuleControlFlag flag = this.appConfigurationEntry[moduleNumber].getControlFlag();
            if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.equals(flag)) {
                for (AuthStatus authStatus : successValue) {
                    if (moduleStatus != authStatus) continue;
                    return false;
                }
                return true;
            }
            if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.equals(flag)) {
                for (AuthStatus authStatus : successValue) {
                    if (moduleStatus != authStatus) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public AuthStatus getReturnStatus(AuthStatus[] successValue, AuthStatus defaultFailStatus, AuthStatus[] status, int position) {
        AuthStatus returnStatus = null;
        for (int moduleNumber = 0; moduleNumber <= position; ++moduleNumber) {
            if (this.appConfigurationEntry[moduleNumber] == null || this.loginModuleConstructors[moduleNumber] == null) continue;
            AppConfigurationEntry.LoginModuleControlFlag flag = this.appConfigurationEntry[moduleNumber].getControlFlag();
            LOG.log(System.Logger.Level.DEBUG, "getReturnStatus - flag: {0}", flag);
            AuthStatus moduleAuthStatus = status[moduleNumber];
            if (flag == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED || flag == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                boolean isSuccessValue = false;
                AuthStatus[] authStatusArray = successValue;
                int n = authStatusArray.length;
                for (int i = 0; i < n; ++i) {
                    AuthStatus authStatus = authStatusArray[i];
                    if (authStatus != moduleAuthStatus) continue;
                    isSuccessValue = true;
                }
                if (isSuccessValue) {
                    if (returnStatus != null) continue;
                    returnStatus = moduleAuthStatus;
                    continue;
                }
                LOG.log(System.Logger.Level.DEBUG, "ReturnStatus - REQUIRED or REQUISITE failure: {0}", moduleAuthStatus);
                return moduleAuthStatus;
            }
            if (flag == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) {
                if (!this.shouldStopProcessingModules(successValue, moduleNumber, moduleAuthStatus)) continue;
                LOG.log(System.Logger.Level.DEBUG, "ReturnStatus - Sufficient success: {0}", moduleAuthStatus);
                return moduleAuthStatus;
            }
            if (flag != AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL || returnStatus != null) continue;
            for (AuthStatus authStatus : successValue) {
                if (moduleAuthStatus != authStatus) continue;
                returnStatus = moduleAuthStatus;
            }
        }
        if (returnStatus != null) {
            LOG.log(System.Logger.Level.DEBUG, "ReturnStatus - result: {0}", returnStatus);
            return returnStatus;
        }
        LOG.log(System.Logger.Level.DEBUG, "ReturnStatus - Default faiure status: {0}", defaultFailStatus);
        return defaultFailStatus;
    }

    private void initialize() {
        boolean found = false;
        boolean foundDefault = false;
        this.instanceWriteLock.lock();
        try {
            this.appConfigurationEntry = this.jaasConfig.getAppConfigurationEntry(this.appContext);
            if (this.appConfigurationEntry == null) {
                this.appConfigurationEntry = this.jaasConfig.getAppConfigurationEntry(DEFAULT_ENTRY_NAME);
                if (this.appConfigurationEntry == null) {
                    this.appConfigurationEntry = new AppConfigurationEntry[0];
                } else {
                    foundDefault = true;
                }
            } else {
                found = true;
            }
            this.loginModuleConstructors = null;
        }
        finally {
            this.instanceWriteLock.unlock();
        }
        if (!found) {
            if (!foundDefault) {
                LOG.log(System.Logger.Level.INFO, "JAASModulesManager no entries matched appContext ({0}) or ({1})", this.appContext, DEFAULT_ENTRY_NAME);
            } else {
                LOG.log(System.Logger.Level.INFO, "JAASModulesManager appContext ({0}) matched ({1})", this.appContext, DEFAULT_ENTRY_NAME);
            }
        }
    }

    private <M> void loadConstructors(M[] template, String authContextID) throws AuthException {
        if (this.loginModuleConstructors == null) {
            try {
                Class<?> moduleType = template.getClass().getComponentType();
                Constructor[] loginModuleCtors = new Constructor[this.appConfigurationEntry.length];
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                for (int i = 0; i < this.appConfigurationEntry.length; ++i) {
                    String loginModuleName = this.appConfigurationEntry[i].getLoginModuleName();
                    try {
                        Class<?> loginModuleClass = Class.forName(loginModuleName, true, loader);
                        if (!moduleType.isAssignableFrom(loginModuleClass)) continue;
                        loginModuleCtors[i] = loginModuleClass.getConstructor(PARAMS);
                        continue;
                    }
                    catch (Throwable t) {
                        LOG.log(System.Logger.Level.WARNING, "Skipping unloadable class: {0} of appCOntext: {1}", loginModuleName, this.appContext);
                        LOG.log(System.Logger.Level.TRACE, "Skipping unloadable class - cause.", t);
                    }
                }
                this.loginModuleConstructors = loginModuleCtors;
            }
            catch (Exception pae) {
                throw (AuthException)new AuthException().initCause(pae.getCause());
            }
        }
    }
}

