/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.pool;

import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.util.pool.AbstractPool;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.enterprise.util.Utility;
import java.lang.invoke.LambdaMetafactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimerTask;
import java.util.function.Supplier;
import java.util.logging.Level;

public class NonBlockingPool
extends AbstractPool {
    protected boolean addedResizeTask;
    protected volatile boolean addedIdleBeanWork;
    protected boolean inResizing;
    private String poolName;
    private TimerTask poolTimerTask;
    private boolean maintainSteadySize;
    private boolean singletonBeanPool;
    private boolean poolClosed;

    protected NonBlockingPool() {
    }

    public NonBlockingPool(long beanId, String poolName, ObjectFactory factory, int steadyPoolSize, int resizeQuantity, int maxPoolSize, int idleTimeoutInSeconds, ClassLoader loader) {
        this(beanId, poolName, factory, steadyPoolSize, resizeQuantity, maxPoolSize, idleTimeoutInSeconds, loader, false);
    }

    public NonBlockingPool(long beanId, String poolName, ObjectFactory factory, int steadyPoolSize, int resizeQuantity, int maxPoolSize, int idleTimeoutInSeconds, ClassLoader loader, boolean singletonBeanPool) {
        this.poolName = poolName;
        this.beanId = beanId;
        this.singletonBeanPool = singletonBeanPool && steadyPoolSize == 1 && maxPoolSize == 1;
        this.initializePool(factory, steadyPoolSize, resizeQuantity, maxPoolSize, idleTimeoutInSeconds, loader);
    }

    protected void initializePool(ObjectFactory factory, int steadyPoolSize, int resizeQuantity, int maxPoolSize, int idleTimeoutInSeconds, ClassLoader loader) {
        this.pooledObjects = new ArrayList();
        this.pooledObjectFactory = factory;
        this.steadyPoolSize = steadyPoolSize <= 0 ? 0 : steadyPoolSize;
        this.resizeQuantity = resizeQuantity <= 0 ? 0 : resizeQuantity;
        this.maxPoolSize = maxPoolSize <= 0 ? Integer.MAX_VALUE : maxPoolSize;
        this.steadyPoolSize = this.steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : this.steadyPoolSize;
        this.idleTimeoutInSeconds = idleTimeoutInSeconds <= 0 || this.singletonBeanPool ? 0 : idleTimeoutInSeconds;
        this.containerClassLoader = loader;
        boolean bl = this.singletonBeanPool ? false : (this.maintainSteadySize = this.steadyPoolSize > 0);
        if (this.idleTimeoutInSeconds > 0 && this.resizeQuantity > 0) {
            try {
                this.poolTimerTask = new PoolResizeTimerTask();
                EjbContainerUtilImpl.getInstance().getTimer().scheduleAtFixedRate(this.poolTimerTask, (long)idleTimeoutInSeconds * 1000L, (long)idleTimeoutInSeconds * 1000L);
                _logger.log(Level.FINE, () -> "[Pool-" + this.poolName + "]: Added PoolResizeTimerTask...");
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Could not add PoolTimerTask. Continuing anyway...", th);
            }
        }
    }

    @Override
    public void setContainerClassLoader(ClassLoader loader) {
        this.containerClassLoader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Object getObject(Object param) {
        List list;
        Object pooledObject;
        boolean toAddResizeTask;
        block24: {
            toAddResizeTask = false;
            pooledObject = null;
            list = this.pooledObjects;
            // MONITORENTER : list
            int size = this.pooledObjects.size();
            if (size > this.steadyPoolSize) {
                ++this.poolSuccess;
                // MONITOREXIT : list
                return this.pooledObjects.remove(size - 1);
            }
            if (size > 0) {
                ++this.poolSuccess;
                if (this.maintainSteadySize && !this.addedResizeTask) {
                    this.addedResizeTask = true;
                    toAddResizeTask = true;
                    pooledObject = this.pooledObjects.remove(size - 1);
                    break block24;
                } else {
                    // MONITOREXIT : list
                    return this.pooledObjects.remove(size - 1);
                }
            }
            if (!this.singletonBeanPool) {
                if (this.maintainSteadySize && !this.addedResizeTask) {
                    this.addedResizeTask = true;
                    toAddResizeTask = true;
                }
                this.poolProbeNotifier.ejbObjectAddedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                ++this.createdCount;
            }
        }
        // MONITOREXIT : list
        if (toAddResizeTask) {
            this.addResizeTaskForImmediateExecution();
        }
        if (pooledObject != null) {
            return pooledObject;
        }
        if (this.singletonBeanPool) {
            list = this.pooledObjects;
            // MONITORENTER : list
        } else {
            try {
                return this.pooledObjectFactory.create(param);
            }
            catch (RuntimeException th) {
                List list2 = this.pooledObjects;
                // MONITORENTER : list2
                this.poolProbeNotifier.ejbObjectAddFailedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                --this.createdCount;
                // MONITOREXIT : list2
                throw th;
            }
        }
        while (this.pooledObjects.isEmpty() && this.createdCount - this.destroyedCount > 0) {
            try {
                this.pooledObjects.wait();
            }
            catch (InterruptedException size) {}
        }
        if (!this.pooledObjects.isEmpty()) {
            // MONITOREXIT : list
            return this.pooledObjects.remove(0);
        }
        try {
            pooledObject = this.pooledObjectFactory.create(param);
            ++this.createdCount;
            // MONITOREXIT : list
            return pooledObject;
        }
        catch (RuntimeException th) {
            this.poolProbeNotifier.ejbObjectAddFailedEvent(this.beanId, this.appName, this.modName, this.ejbName);
            throw th;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResizeTaskForImmediateExecution() {
        try {
            ReSizeWork work = new ReSizeWork();
            EjbContainerUtilImpl.getInstance().addWork(work);
            _logger.log(Level.FINE, () -> "[Pool-" + this.poolName + "]: Added PoolResizeTimerTask...");
        }
        catch (Exception ex) {
            List list = this.pooledObjects;
            synchronized (list) {
                this.addedResizeTask = false;
            }
            _logger.log(Level.WARNING, ex, () -> "[Pool-" + this.poolName + "]: Cannot perform  pool resize task");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(Object object) {
        List list = this.pooledObjects;
        synchronized (list) {
            if (this.pooledObjects.size() < this.maxPoolSize) {
                this.pooledObjects.add(object);
                if (this.singletonBeanPool) {
                    this.pooledObjects.notify();
                }
                return;
            }
            this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
            ++this.destroyedCount;
        }
        try {
            this.pooledObjectFactory.destroy(object);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "exception in returnObj", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyObject(Object object) {
        List list = this.pooledObjects;
        synchronized (list) {
            this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
            ++this.destroyedCount;
            if (this.singletonBeanPool) {
                this.pooledObjects.notify();
            }
        }
        try {
            this.pooledObjectFactory.destroy(object);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "exception in destroyObject", ex);
        }
    }

    public void prepopulate(int count) {
        this.steadyPoolSize = count <= 0 ? 0 : count;
        int n = this.steadyPoolSize = this.steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : this.steadyPoolSize;
        if (this.steadyPoolSize > 0) {
            this.preload(this.steadyPoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preload(int count) {
        int sz;
        ArrayList<Object> pooledObjectnewInstances = new ArrayList<Object>(count);
        try {
            for (int i = 0; i < count; ++i) {
                pooledObjectnewInstances.add(this.pooledObjectFactory.create(null));
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        if ((sz = pooledObjectnewInstances.size()) == 0) {
            return;
        }
        List list = this.pooledObjects;
        synchronized (list) {
            int n = this.pooledObjects.size();
            int addsz = sz;
            if (n + sz > this.maxPoolSize) {
                addsz = this.maxPoolSize - n;
            }
            for (int i = 0; i < addsz; ++i) {
                this.pooledObjects.add(pooledObjectnewInstances.remove(0));
            }
            this.createdCount += sz;
        }
        for (Object e : pooledObjectnewInstances) {
            this.destroyObject(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List list = this.pooledObjects;
        synchronized (list) {
            if (this.poolTimerTask != null) {
                try {
                    this.poolTimerTask.cancel();
                    _logger.log(Level.FINE, () -> "[Pool-" + this.poolName + "]: Cancelled pool timer task  at: " + String.valueOf(new Date()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            _logger.log(Level.FINE, () -> "[Pool-" + this.poolName + "]: Destroying " + this.pooledObjects.size() + " beans from the pool...");
            ClassLoader origLoader = Utility.setContextClassLoader((ClassLoader)this.containerClassLoader);
            Object[] array = this.pooledObjects.toArray();
            for (int i = 0; i < array.length; ++i) {
                try {
                    this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                    ++this.destroyedCount;
                    try {
                        this.pooledObjectFactory.destroy(array[i]);
                    }
                    catch (Throwable th) {
                        _logger.log(Level.FINE, "exception in close", th);
                    }
                    continue;
                }
                catch (Throwable th) {
                    _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Error while destroying", th);
                }
            }
            _logger.log(Level.FINE, "Pool-" + this.poolName + "]: Pool closed....");
            this.pooledObjects.clear();
            this.unregisterProbeProvider();
            Utility.setContextClassLoader((ClassLoader)origLoader);
            this.poolClosed = true;
            this.pooledObjects = null;
            this.pooledObjectFactory = null;
            this.poolTimerTask = null;
            this.containerClassLoader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void remove(int count) {
        ArrayList removeList = new ArrayList();
        List list = this.pooledObjects;
        synchronized (list) {
            int size = this.pooledObjects.size();
            for (int i = 0; i < count && size > 0; ++i) {
                removeList.add(this.pooledObjects.remove(--size));
                this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                ++this.destroyedCount;
            }
        }
        int sz = removeList.size();
        for (int i = 0; i < sz; ++i) {
            try {
                this.pooledObjectFactory.destroy(removeList.get(i));
                continue;
            }
            catch (Throwable th) {
                _logger.log(Level.FINE, "exception in remove", th);
            }
        }
    }

    @Override
    protected void removeIdleObjects() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doResize() {
        block63: {
            block62: {
                block60: {
                    block58: {
                        if (this.poolClosed) {
                            return;
                        }
                        currentThread = Thread.currentThread();
                        previousClassLoader = currentThread.getContextClassLoader();
                        startTime = 0L;
                        enteredResizeBlock = false;
                        if (System.getSecurityManager() == null) {
                            currentThread.setContextClassLoader(this.containerClassLoader);
                        } else {
                            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    currentThread.setContextClassLoader(NonBlockingPool.this.containerClassLoader);
                                    return null;
                                }
                            });
                        }
                        NonBlockingPool._logger.log(Level.FINE, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doResize$5(), ()Ljava/lang/String;)((NonBlockingPool)this));
                        startTime = System.currentTimeMillis();
                        removeList = new ArrayList<E>();
                        populateCount = 0L;
                        var9_9 = this.pooledObjects;
                        synchronized (var9_9) {
                            if (!this.inResizing && !this.poolClosed) ** break block57
                            // MONITOREXIT @DISABLED, blocks:[0, 16, 1] lbl21 : MonitorExitStatement: MONITOREXIT : var9_9
                            if (!enteredResizeBlock) break block58;
                            var10_11 = this.pooledObjects;
                        }
                        synchronized (var10_11) {
                            this.inResizing = false;
                        }
                    }
                    if (System.getSecurityManager() == null) {
                        currentThread.setContextClassLoader(previousClassLoader);
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){
                            final /* synthetic */ Thread val$currentThread;
                            final /* synthetic */ ClassLoader val$previousClassLoader;
                            {
                                this.val$currentThread = thread;
                                this.val$previousClassLoader = classLoader;
                            }

                            @Override
                            public Object run() {
                                this.val$currentThread.setContextClassLoader(this.val$previousClassLoader);
                                return null;
                            }
                        });
                    }
                    return;
                    {
                        enteredResizeBlock = true;
                        this.inResizing = true;
                        curSize = this.pooledObjects.size();
                        if (curSize <= this.steadyPoolSize) ** GOTO lbl72
                        if (this.idleTimeoutInSeconds > 0 && this.resizeQuantity > 0) ** break block59
                        // MONITOREXIT @DISABLED, blocks:[16, 3] lbl44 : MonitorExitStatement: MONITOREXIT : var9_9
                        if (!enteredResizeBlock) break block60;
                        var11_14 = this.pooledObjects;
                    }
                    synchronized (var11_14) {
                        this.inResizing = false;
                    }
                }
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(previousClassLoader);
                } else {
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
                return;
                {
                    victimCount = curSize > this.steadyPoolSize + this.resizeQuantity ? this.resizeQuantity : curSize - this.steadyPoolSize;
                    allowedIdleTime = System.currentTimeMillis() - (long)this.idleTimeoutInSeconds * 1000L;
                    NonBlockingPool._logger.log(Level.FINE, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doResize$6(int ), ()Ljava/lang/String;)((NonBlockingPool)this, (int)victimCount));
                    for (i = 0; i < victimCount && (ejbContext = (EJBContextImpl)this.pooledObjects.get(0)).getLastTimeUsed() <= allowedIdleTime; ++i) {
                        removeList.add(this.pooledObjects.remove(0));
                        this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                        ++this.destroyedCount;
                    }
                    ** GOTO lbl101
lbl72:
                    // 1 sources

                    if (curSize >= this.steadyPoolSize) ** GOTO lbl101
                    if (this.maintainSteadySize) ** break block61
                    // MONITOREXIT @DISABLED, blocks:[16, 5] lbl74 : MonitorExitStatement: MONITOREXIT : var9_9
                    if (!enteredResizeBlock) break block62;
                    victimCount = this.pooledObjects;
                }
                synchronized (victimCount) {
                    this.inResizing = false;
                }
            }
            if (System.getSecurityManager() == null) {
                currentThread.setContextClassLoader(previousClassLoader);
            } else {
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            }
            return;
            {
                if (this.resizeQuantity <= 0) {
                    populateCount = this.steadyPoolSize - curSize;
                } else {
                    while ((long)curSize + populateCount < (long)this.steadyPoolSize) {
                        populateCount += (long)this.resizeQuantity;
                    }
                    if ((long)curSize + populateCount > (long)this.maxPoolSize) {
                        populateCount -= (long)curSize + populateCount - (long)this.maxPoolSize;
                    }
                }
lbl101:
                // 6 sources

                // MONITOREXIT @DISABLED, blocks:[16, 7, 8] lbl101 : MonitorExitStatement: MONITOREXIT : var9_9
                {
                    catch (Throwable var17_23) {
                        throw var17_23;
                    }
                }
                if (removeList.size() > 0) {
                    sz = removeList.size();
                    for (i = 0; i < sz; ++i) {
                        try {
                            this.pooledObjectFactory.destroy(removeList.get(i));
                            continue;
                        }
                        catch (Throwable th) {
                            NonBlockingPool._logger.log(Level.FINE, "exception in doResize", th);
                        }
                    }
                }
                if (populateCount > 0L) {
                    if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                        NonBlockingPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Attempting to preload " + populateCount + " beans. CurSize/MaxPoolSize: " + this.pooledObjects.size() + "/" + this.maxPoolSize);
                    }
                    this.preload((int)populateCount);
                    NonBlockingPool._logger.log(Level.FINE, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doResize$7(), ()Ljava/lang/String;)((NonBlockingPool)this));
                }
                if (!enteredResizeBlock) break block63;
                removeList = this.pooledObjects;
            }
            synchronized (removeList) {
                this.inResizing = false;
            }
        }
        if (System.getSecurityManager() == null) {
            currentThread.setContextClassLoader(previousClassLoader);
        } else {
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        }
        ** GOTO lbl167
        {
            catch (Throwable th) {
                block64: {
                    try {
                        NonBlockingPool._logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Exception during reSize", th);
                        if (!enteredResizeBlock) break block64;
                        th = this.pooledObjects;
                    }
                    catch (Throwable var20_26) {
                        if (enteredResizeBlock) {
                            var21_27 = this.pooledObjects;
                            synchronized (var21_27) {
                                this.inResizing = false;
                            }
                        }
                        if (System.getSecurityManager() == null) {
                            currentThread.setContextClassLoader(previousClassLoader);
                        } else {
                            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                        }
                        throw var20_26;
                    }
                    synchronized (th) {
                        this.inResizing = false;
                    }
                }
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(previousClassLoader);
                } else {
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
            }
            endTime = System.currentTimeMillis();
            if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                NonBlockingPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize completed at: " + String.valueOf(new Date()) + "; after reSize: " + this.getAllAttrValues());
                NonBlockingPool._logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize took: " + (double)(endTime - startTime) / 1000.0 + " seconds.");
            }
            return;
        }
    }

    @Override
    public String getAllAttrValues() {
        StringBuffer sbuf = new StringBuffer("[Pool-" + this.poolName + "] ");
        sbuf.append("CC=").append(this.createdCount).append("; ").append("DC=").append(this.destroyedCount).append("; ").append("CS=").append(this.pooledObjects.size()).append("; ").append("SS=").append(this.steadyPoolSize).append("; ").append("MS=").append(this.maxPoolSize).append(";");
        return sbuf.toString();
    }

    private /* synthetic */ String lambda$doResize$7() {
        return "[Pool-" + this.poolName + "]: After preload CurSize/MaxPoolSize: " + this.pooledObjects.size() + "/" + this.maxPoolSize;
    }

    private /* synthetic */ String lambda$doResize$6(int victimCount) {
        return "[Pool-" + this.poolName + "]: Resize:: reducing  pool size by: " + victimCount;
    }

    private /* synthetic */ String lambda$doResize$5() {
        return "[Pool-" + this.poolName + "]: Resize started at: " + String.valueOf(new Date()) + " steadyPoolSize ::" + this.steadyPoolSize + " resizeQuantity ::" + this.resizeQuantity + " maxPoolSize ::" + this.maxPoolSize;
    }

    private class PoolResizeTimerTask
    extends TimerTask {
        PoolResizeTimerTask() {
        }

        @Override
        public void run() {
            try {
                if (NonBlockingPool.this.addedIdleBeanWork) {
                    return;
                }
                NonBlockingPool.this.addedIdleBeanWork = true;
                IdleBeanWork work = new IdleBeanWork();
                EjbContainerUtilImpl.getInstance().addWork(work);
            }
            catch (Exception ex) {
                NonBlockingPool.this.addedIdleBeanWork = false;
                AbstractPool._logger.log(Level.WARNING, "[Pool-" + NonBlockingPool.this.poolName + "]: Cannot perform  pool idle bean cleanup", ex);
            }
        }
    }

    private class ReSizeWork
    implements Runnable {
        private ReSizeWork() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                NonBlockingPool.this.doResize();
            }
            catch (Exception ex) {
                AbstractPool._logger.log(Level.WARNING, "[Pool-" + NonBlockingPool.this.poolName + "]: Exception during reSize", ex);
            }
            finally {
                List list = NonBlockingPool.this.pooledObjects;
                synchronized (list) {
                    NonBlockingPool.this.addedResizeTask = false;
                }
            }
        }
    }

    private class IdleBeanWork
    implements Runnable {
        private IdleBeanWork() {
        }

        @Override
        public void run() {
            try {
                NonBlockingPool.this.doResize();
            }
            catch (Exception exception) {
            }
            finally {
                NonBlockingPool.this.addedIdleBeanWork = false;
            }
        }
    }
}

