/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.Hyperlink;
import jakarta.el.ValueExpression;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.PhaseId;

public final class Breadcrumbs
extends UIComponentBase
implements NamingContainer {
    private Hyperlink[] pages = null;
    private String style = null;
    private String styleClass = null;
    private int tabIndex = Integer.MIN_VALUE;
    private boolean tabIndexSet = false;
    private boolean immediate = true;
    private boolean immediateSet = false;
    private boolean visible = false;
    private boolean visibleSet = false;

    public Breadcrumbs() {
        this.setRendererType("com.sun.webui.jsf.Breadcrumbs");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.Breadcrumbs";
    }

    public void setId(String id) {
        super.setId(id);
    }

    public void setRendered(boolean rendered) {
        super.setRendered(rendered);
    }

    public Hyperlink[] getPages() {
        if (this.pages != null) {
            return this.pages;
        }
        ValueExpression vb = this.getValueExpression("pages");
        if (vb != null) {
            return (Hyperlink[])vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setPages(Hyperlink[] newPages) {
        this.pages = newPages;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    public int getTabIndex() {
        if (this.tabIndexSet) {
            return this.tabIndex;
        }
        ValueExpression vb = this.getValueExpression("tabIndex");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setTabIndex(int newTabIndex) {
        this.tabIndex = newTabIndex;
        this.tabIndexSet = true;
    }

    public boolean isImmediate() {
        if (this.immediateSet) {
            return this.immediate;
        }
        ValueExpression vb = this.getValueExpression("immediate");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setImmediate(boolean newImmediate) {
        this.immediate = newImmediate;
        this.immediateSet = true;
    }

    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    public void processDecodes(FacesContext context) {
        if (this.isRendered()) {
            if (this.getPages() != null) {
                for (Hyperlink hyperlink : this.getPages()) {
                    UIComponent parent = hyperlink.getParent();
                    hyperlink.setParent((UIComponent)this);
                    hyperlink.processDecodes(context);
                    hyperlink.setParent(parent);
                }
            } else {
                super.processDecodes(context);
            }
        }
    }

    public void processValidators(FacesContext context) {
        if (this.isRendered()) {
            if (this.getPages() != null) {
                for (Hyperlink hyperlink : this.getPages()) {
                    UIComponent parent = hyperlink.getParent();
                    hyperlink.setParent((UIComponent)this);
                    hyperlink.processValidators(context);
                    hyperlink.setParent(parent);
                }
            } else {
                super.processValidators(context);
            }
        }
    }

    public void processUpdates(FacesContext context) {
        if (this.isRendered()) {
            if (this.getPages() != null) {
                for (Hyperlink hyperlink : this.getPages()) {
                    UIComponent parent = hyperlink.getParent();
                    hyperlink.setParent((UIComponent)this);
                    hyperlink.processUpdates(context);
                    hyperlink.setParent(parent);
                }
            } else {
                super.processUpdates(context);
            }
        }
    }

    public void queueEvent(FacesEvent event) {
        if (this.isImmediate() && event instanceof ActionEvent) {
            event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        }
        super.queueEvent(event);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        if (values[1] != null) {
            Object[] pageValues = (Object[])values[1];
            this.pages = new Hyperlink[pageValues.length];
            for (int i = 0; i < pageValues.length; ++i) {
                this.pages[i] = new Hyperlink();
                this.pages[i].restoreState(context, pageValues[i]);
            }
        }
        this.style = (String)values[2];
        this.styleClass = (String)values[3];
        this.tabIndex = (Integer)values[4];
        this.tabIndexSet = (Boolean)values[5];
        this.immediate = (Boolean)values[6];
        this.immediateSet = (Boolean)values[7];
        this.visible = (Boolean)values[8];
        this.visibleSet = (Boolean)values[9];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[10];
        values[0] = super.saveState(context);
        if (this.pages != null) {
            Object[] pageValues = new Object[this.pages.length];
            for (int i = 0; i < this.pages.length; ++i) {
                pageValues[i] = this.pages[i].saveState(context);
            }
            values[1] = pageValues;
        }
        values[2] = this.style;
        values[3] = this.styleClass;
        values[4] = this.tabIndex;
        values[5] = this.tabIndexSet ? Boolean.TRUE : Boolean.FALSE;
        values[6] = this.immediate ? Boolean.TRUE : Boolean.FALSE;
        values[7] = this.immediateSet ? Boolean.TRUE : Boolean.FALSE;
        values[8] = this.visible ? Boolean.TRUE : Boolean.FALSE;
        values[9] = this.visibleSet ? Boolean.TRUE : Boolean.FALSE;
        return values;
    }
}

