/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.iiop.security.CSIV2TaggedComponentInfo;
import com.sun.enterprise.iiop.security.Lookups;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.util.IIOPUtils;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.orb.admin.config.IiopListener;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;

public class SecIORInterceptor
extends LocalObject
implements IORInterceptor {
    private static final Logger LOG = LogDomains.getLogger(SecIORInterceptor.class, (String)"jakarta.enterprise.system.core.security", (boolean)false);
    private final Codec codec;
    private final GMSAdapterService gmsAdapterService;
    private GMSAdapter gmsAdapter;
    private final ORB orb;

    public SecIORInterceptor(Codec c, ORB orb) {
        this.codec = c;
        this.orb = orb;
        this.gmsAdapterService = Lookups.getGMSAdapterService();
        this.gmsAdapter = this.gmsAdapterService == null ? null : this.gmsAdapterService.getGMSAdapter();
    }

    public void destroy() {
    }

    public String name() {
        return "SecIORInterceptor";
    }

    public void establish_components(IORInfo iorInfo) {
        try {
            LOG.log(Level.FINE, "SecIORInterceptor.establish_components->:");
            this.addCSIv2Components(iorInfo);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception in establish_components", e);
        }
        finally {
            LOG.log(Level.FINE, "SecIORInterceptor.establish_components<-:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCSIv2Components(IORInfo iorInfo) {
        EjbDescriptor desc;
        block3: {
            desc = null;
            try {
                LOG.log(Level.FINE, ".addCSIv2Components->: {0}", iorInfo);
                if (this.gmsAdapter == null) break block3;
            }
            catch (Throwable throwable) {
                LOG.log(Level.FINE, ".addCSIv2Components<-: {0} {1}", new Object[]{iorInfo, desc});
                throw throwable;
            }
            LOG.log(Level.FINE, ".addCSIv2Components<-: {0} {1}", new Object[]{iorInfo, desc});
            return;
        }
        LOG.log(Level.FINE, ".addCSIv2Components ");
        int sslMutualAuthPort = this.getServerPort("SSL_MUTUALAUTH");
        LOG.log(Level.FINE, ".addCSIv2Components: sslMutualAuthPort: {0}", sslMutualAuthPort);
        CSIV2TaggedComponentInfo ctc = new CSIV2TaggedComponentInfo(this.orb, sslMutualAuthPort);
        desc = ctc.getEjbDescriptor(iorInfo);
        int sslport = this.getServerPort("SSL");
        LOG.log(Level.FINE, ".addCSIv2Components: sslport: {0}", sslport);
        TaggedComponent csiv2Comp = null;
        csiv2Comp = desc != null ? ctc.createSecurityTaggedComponent(sslport, desc) : ctc.createSecurityTaggedComponent(sslport);
        iorInfo.add_ior_component(csiv2Comp);
        LOG.log(Level.FINE, ".addCSIv2Components<-: {0} {1}", new Object[]{iorInfo, desc});
    }

    private int getServerPort(String mech) {
        IiopListener[] iiopListenerBeans;
        List listenersList = IIOPUtils.getInstance().getIiopService().getIiopListener();
        for (IiopListener ilisten : iiopListenerBeans = listenersList.toArray(new IiopListener[listenersList.size()])) {
            if (!(mech.equalsIgnoreCase("SSL") ? ilisten.getSecurityEnabled().equalsIgnoreCase("true") && ilisten.getSsl() != null && !ilisten.getSsl().getClientAuthEnabled().equalsIgnoreCase("true") : (mech.equalsIgnoreCase("SSL_MUTUALAUTH") ? ilisten.getSecurityEnabled().equalsIgnoreCase("true") && ilisten.getSsl() != null && ilisten.getSsl().getClientAuthEnabled().equalsIgnoreCase("true") : !ilisten.getSecurityEnabled().equalsIgnoreCase("true")))) continue;
            return Integer.parseInt(ilisten.getPort());
        }
        return -1;
    }
}

