/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.io;

import com.sun.messaging.jmq.util.io.ClassFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class FilteringObjectInputStream
extends ObjectInputStream {
    public FilteringObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass descriptor) throws ClassNotFoundException, IOException {
        String className = descriptor.getName();
        if (className != null && className.length() > 0 && ClassFilter.isBlackListed(className)) {
            throw new InvalidClassException("Unauthorized deserialization attempt", descriptor.getName());
        }
        return super.resolveClass(descriptor);
    }
}

