/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.runtime.connector.MapElement;
import com.sun.enterprise.deployment.runtime.connector.Principal;
import com.sun.enterprise.deployment.runtime.connector.ResourceAdapter;
import com.sun.enterprise.deployment.runtime.connector.RoleMap;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.deployment.common.Descriptor;

public class RuntimeDescriptorFactory {
    private static final Logger LOG = DOLUtils.getDefaultLogger();
    private static Map<String, Class<? extends Descriptor>> descriptorClasses;

    private RuntimeDescriptorFactory() {
    }

    private static void initMapping() {
        descriptorClasses = new ConcurrentHashMap<String, Class<? extends Descriptor>>();
        RuntimeDescriptorFactory.register(new XMLElement("resource-description"), ResourceReferenceDescriptor.class);
        RuntimeDescriptorFactory.register(new XMLElement("resource-env-description"), ResourceEnvReferenceDescriptor.class);
        RuntimeDescriptorFactory.register(new XMLElement("ejb-reference-description"), EjbReferenceDescriptor.class);
        RuntimeDescriptorFactory.register(new XMLElement("principal"), Principal.class);
        RuntimeDescriptorFactory.register(new XMLElement("backend-principal"), Principal.class);
        RuntimeDescriptorFactory.register(new XMLElement("map-element"), MapElement.class);
        RuntimeDescriptorFactory.register(new XMLElement("role-map"), RoleMap.class);
        RuntimeDescriptorFactory.register(new XMLElement("resource-adapter"), ResourceAdapter.class);
    }

    public static void register(XMLElement xmlElement, Class<? extends Descriptor> clazz) {
        LOG.log(Level.CONFIG, "Registering {0} to handle xml path {1}", new Object[]{clazz, xmlElement});
        descriptorClasses.put(xmlElement.getQName(), clazz);
    }

    public static <T extends Descriptor> T getDescriptor(String xmlPath) {
        try {
            Class<T> c = RuntimeDescriptorFactory.getDescriptorClass(xmlPath);
            if (c == null) {
                return null;
            }
            return (T)((Descriptor)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create a descriptor instance for " + xmlPath, e);
        }
    }

    public static <T extends Descriptor> Class<T> getDescriptorClass(String xmlPath) {
        String xpathPart = xmlPath;
        do {
            LOG.log(Level.FINEST, "Looking descriptor class for {0}", xpathPart);
            Class<? extends Descriptor> clazz = descriptorClasses.get(xpathPart);
            if (clazz == null) continue;
            return clazz;
        } while ((xpathPart = xpathPart.indexOf(47) == -1 ? null : xpathPart.substring(xpathPart.indexOf(47) + 1)) != null);
        throw new IllegalStateException("No descriptor registered for " + xmlPath);
    }

    static {
        RuntimeDescriptorFactory.initMapping();
    }
}

