/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.identitystores;

import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.credential.UsernamePasswordCredential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.IdentityStorePermission;
import jakarta.security.enterprise.identitystore.LdapIdentityStoreDefinition;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InvalidSearchControlsException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.glassfish.soteria.identitystores.IdentityStoreConfigurationException;
import org.glassfish.soteria.identitystores.IdentityStoreRuntimeException;

public class LdapIdentityStore
implements IdentityStore {
    private static final String DEFAULT_USER_FILTER = "(&(%s=%s)(|(objectclass=user)(objectclass=person)(objectclass=inetOrgPerson)(objectclass=organizationalPerson))(!(objectclass=computer)))";
    private static final String DEFAULT_GROUP_FILTER = "(&(%s=%s)(|(objectclass=group)(objectclass=groupofnames)(objectclass=groupofuniquenames)))";
    private final LdapIdentityStoreDefinition ldapIdentityStoreDefinition;
    private final Set<IdentityStore.ValidationType> validationTypes;

    protected LdapIdentityStore() {
        this.ldapIdentityStoreDefinition = null;
        this.validationTypes = null;
    }

    public LdapIdentityStore(LdapIdentityStoreDefinition ldapIdentityStoreDefinition) {
        this.ldapIdentityStoreDefinition = ldapIdentityStoreDefinition;
        this.validationTypes = Collections.unmodifiableSet(new HashSet<IdentityStore.ValidationType>(Arrays.asList(ldapIdentityStoreDefinition.useFor())));
    }

    public CredentialValidationResult validate(Credential credential) {
        if (credential instanceof UsernamePasswordCredential) {
            return this.validate((UsernamePasswordCredential)credential);
        }
        return CredentialValidationResult.NOT_VALIDATED_RESULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CredentialValidationResult validate(UsernamePasswordCredential usernamePasswordCredential) {
        LdapContext searchContext = this.createSearchLdapContext();
        try {
            String callerDn = this.getCallerDn(searchContext, usernamePasswordCredential.getCaller());
            CredentialValidationResult credentialValidationResult = this.validateCallerAndGetGroups(searchContext, callerDn, usernamePasswordCredential);
            return credentialValidationResult;
        }
        finally {
            LdapIdentityStore.closeContext(searchContext);
        }
    }

    private String getCallerDn(LdapContext searchContext, String callerName) {
        String callerDn = null;
        callerDn = !this.ldapIdentityStoreDefinition.callerBaseDn().isEmpty() && this.ldapIdentityStoreDefinition.callerSearchBase().isEmpty() ? String.format("%s=%s,%s", this.ldapIdentityStoreDefinition.callerNameAttribute(), callerName, this.ldapIdentityStoreDefinition.callerBaseDn()) : this.searchCaller(searchContext, callerName);
        return callerDn;
    }

    private CredentialValidationResult validateCallerAndGetGroups(LdapContext searchContext, String callerDn, UsernamePasswordCredential usernamePasswordCredential) {
        if (callerDn == null) {
            return CredentialValidationResult.INVALID_RESULT;
        }
        LdapContext callerContext = this.createCallerLdapContext(callerDn, new String(usernamePasswordCredential.getPassword().getValue()));
        if (callerContext == null) {
            return CredentialValidationResult.INVALID_RESULT;
        }
        LdapIdentityStore.closeContext(callerContext);
        Set<String> groups = null;
        if (this.validationTypes().contains(IdentityStore.ValidationType.PROVIDE_GROUPS)) {
            groups = this.retrieveGroupsForCallerDn(searchContext, callerDn);
        }
        return new CredentialValidationResult(null, usernamePasswordCredential.getCaller(), callerDn, null, groups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getCallerGroups(CredentialValidationResult validationResult) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)new IdentityStorePermission("getGroups"));
        }
        LdapContext searchContext = this.createSearchLdapContext();
        try {
            String callerDn = validationResult.getCallerDn();
            if (callerDn == null || callerDn.isEmpty()) {
                callerDn = this.getCallerDn(searchContext, validationResult.getCallerPrincipal().getName());
            }
            Set<String> set = this.retrieveGroupsForCallerDn(searchContext, callerDn);
            return set;
        }
        finally {
            LdapIdentityStore.closeContext(searchContext);
        }
    }

    private Set<String> retrieveGroupsForCallerDn(LdapContext searchContext, String callerDn) {
        if (callerDn == null || callerDn.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.ldapIdentityStoreDefinition.groupSearchBase().isEmpty() && !this.ldapIdentityStoreDefinition.groupMemberOfAttribute().isEmpty()) {
            return this.retrieveGroupsFromCallerObject(callerDn, searchContext);
        }
        return this.retrieveGroupsBySearching(callerDn, searchContext);
    }

    private Set<String> retrieveGroupsBySearching(String callerDn, LdapContext searchContext) {
        List<SearchResult> searchResults = this.searchGroups(searchContext, callerDn);
        HashSet<String> groups = new HashSet<String>();
        try {
            for (SearchResult searchResult : searchResults) {
                Attribute attribute = searchResult.getAttributes().get(this.ldapIdentityStoreDefinition.groupNameAttribute());
                if (attribute == null) continue;
                for (Object group : Collections.list(attribute.getAll())) {
                    if (group == null) continue;
                    groups.add(group.toString());
                }
            }
        }
        catch (NamingException e) {
            throw new IdentityStoreRuntimeException(e);
        }
        return groups;
    }

    private Set<String> retrieveGroupsFromCallerObject(String callerDn, LdapContext searchContext) {
        try {
            Attributes attributes = searchContext.getAttributes(callerDn, new String[]{this.ldapIdentityStoreDefinition.groupMemberOfAttribute()});
            Attribute memberOfAttribute = attributes.get(this.ldapIdentityStoreDefinition.groupMemberOfAttribute());
            HashSet<String> groups = new HashSet<String>();
            if (memberOfAttribute != null) {
                for (Object group : Collections.list(memberOfAttribute.getAll())) {
                    String groupName;
                    if (group == null || (groupName = LdapIdentityStore.getGroupNameFromDn(group.toString(), this.ldapIdentityStoreDefinition.groupNameAttribute())) == null) continue;
                    groups.add(groupName);
                }
            }
            return groups;
        }
        catch (NamingException e) {
            throw new IdentityStoreRuntimeException(e);
        }
    }

    private static String getGroupNameFromDn(String dnString, String groupNameAttribute) throws NamingException {
        LdapName dn = new LdapName(dnString);
        Attribute attribute = dn.getRdn(dn.size() - 1).toAttributes().get(groupNameAttribute);
        if (attribute == null) {
            throw new IdentityStoreConfigurationException("Group name attribute '" + groupNameAttribute + "' not found for DN: " + dnString);
        }
        return attribute.get(0).toString();
    }

    private String searchCaller(LdapContext searchContext, String callerName) {
        String filter = null;
        filter = this.ldapIdentityStoreDefinition.callerSearchFilter() != null && !this.ldapIdentityStoreDefinition.callerSearchFilter().trim().isEmpty() ? String.format(this.ldapIdentityStoreDefinition.callerSearchFilter(), callerName) : String.format(DEFAULT_USER_FILTER, this.ldapIdentityStoreDefinition.callerNameAttribute(), callerName);
        List<SearchResult> callerDn = LdapIdentityStore.search(searchContext, this.ldapIdentityStoreDefinition.callerSearchBase(), filter, this.getCallerSearchControls());
        if (callerDn.size() > 1) {
            // empty if block
        }
        if (callerDn.size() == 1) {
            return callerDn.get(0).getNameInNamespace();
        }
        return null;
    }

    private List<SearchResult> searchGroups(LdapContext searchContext, String callerDn) {
        String filter = null;
        filter = this.ldapIdentityStoreDefinition.groupSearchFilter() != null && !this.ldapIdentityStoreDefinition.groupSearchFilter().trim().isEmpty() ? String.format(this.ldapIdentityStoreDefinition.groupSearchFilter(), callerDn) : String.format(DEFAULT_GROUP_FILTER, this.ldapIdentityStoreDefinition.groupMemberAttribute(), callerDn);
        return LdapIdentityStore.search(searchContext, this.ldapIdentityStoreDefinition.groupSearchBase(), filter, this.getGroupSearchControls());
    }

    private static List<SearchResult> search(LdapContext searchContext, String searchBase, String searchFilter, SearchControls controls) {
        try {
            return Collections.list(searchContext.search(searchBase, searchFilter, controls));
        }
        catch (NameNotFoundException e) {
            throw new IdentityStoreConfigurationException("Invalid searchBase", e);
        }
        catch (InvalidSearchFilterException e) {
            throw new IdentityStoreConfigurationException("Invalid search filter", e);
        }
        catch (InvalidSearchControlsException e) {
            throw new IdentityStoreConfigurationException("Invalid search controls", e);
        }
        catch (Exception e) {
            throw new IdentityStoreRuntimeException(e);
        }
    }

    private SearchControls getCallerSearchControls() {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(LdapIdentityStore.convertScopeValue(this.ldapIdentityStoreDefinition.callerSearchScope()));
        controls.setCountLimit(this.ldapIdentityStoreDefinition.maxResults());
        controls.setTimeLimit(this.ldapIdentityStoreDefinition.readTimeout());
        return controls;
    }

    private SearchControls getGroupSearchControls() {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(LdapIdentityStore.convertScopeValue(this.ldapIdentityStoreDefinition.groupSearchScope()));
        controls.setCountLimit(this.ldapIdentityStoreDefinition.maxResults());
        controls.setTimeLimit(this.ldapIdentityStoreDefinition.readTimeout());
        controls.setReturningAttributes(new String[]{this.ldapIdentityStoreDefinition.groupNameAttribute()});
        return controls;
    }

    private static int convertScopeValue(LdapIdentityStoreDefinition.LdapSearchScope searchScope) {
        if (searchScope == LdapIdentityStoreDefinition.LdapSearchScope.ONE_LEVEL) {
            return 1;
        }
        if (searchScope == LdapIdentityStoreDefinition.LdapSearchScope.SUBTREE) {
            return 2;
        }
        return 1;
    }

    private LdapContext createSearchLdapContext() {
        try {
            return LdapIdentityStore.createLdapContext(this.ldapIdentityStoreDefinition.url(), this.ldapIdentityStoreDefinition.bindDn(), this.ldapIdentityStoreDefinition.bindDnPassword());
        }
        catch (AuthenticationException e) {
            throw new IdentityStoreConfigurationException("Bad bindDn or bindPassword for: " + this.ldapIdentityStoreDefinition.bindDn(), e);
        }
    }

    private LdapContext createCallerLdapContext(String bindDn, String bindDnPassword) {
        try {
            return LdapIdentityStore.createLdapContext(this.ldapIdentityStoreDefinition.url(), bindDn, bindDnPassword);
        }
        catch (AuthenticationException e) {
            return null;
        }
    }

    private static LdapContext createLdapContext(String url, String bindDn, String bindCredential) throws AuthenticationException {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        environment.put("java.naming.provider.url", url);
        environment.put("java.naming.security.authentication", "simple");
        environment.put("java.naming.security.principal", bindDn);
        environment.put("java.naming.security.credentials", bindCredential);
        try {
            return new InitialLdapContext(environment, null);
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (CommunicationException e) {
            throw new IdentityStoreConfigurationException("Bad connection URL: " + url, e);
        }
        catch (Exception e) {
            throw new IdentityStoreRuntimeException(e);
        }
    }

    private static void closeContext(LdapContext ldapContext) {
        try {
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public int priority() {
        return this.ldapIdentityStoreDefinition.priority();
    }

    public Set<IdentityStore.ValidationType> validationTypes() {
        return this.validationTypes;
    }
}

