/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.modify;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.modify.Animal;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.modify.Cat;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.modify.Cute;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.modify.ModifyingExtension;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.modify.PersianStereotype;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.modify.Wild;
import org.jboss.cdi.tck.util.Assert;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class SetBeanAttributesTest
extends AbstractTest {
    @Inject
    ModifyingExtension extension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SetBeanAttributesTest.class)).withExtension(ModifyingExtension.class)).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL).alternatives(Cat.class))).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="bc"), @SpecAssertion(section="process_bean_attributes", id="ca")})
    public void testBeanModified() {
        org.testng.Assert.assertEquals((int)this.getCurrentManager().getBeans(Cat.class, new Annotation[]{Default.Literal.INSTANCE}).size(), (int)0);
        org.testng.Assert.assertEquals((int)this.getCurrentManager().getBeans(Animal.class, new Annotation[]{Any.Literal.INSTANCE}).size(), (int)0);
        org.testng.Assert.assertEquals((int)this.getCurrentManager().getBeans(Animal.class, new Annotation[]{new Wild.Literal(false)}).size(), (int)0);
        org.testng.Assert.assertEquals((int)this.getCurrentManager().getBeans(Cat.class, new Annotation[]{new Wild.Literal(true)}).size(), (int)1);
        org.testng.Assert.assertEquals((int)this.getCurrentManager().getBeans(Cat.class, new Annotation[]{new Cute.Literal()}).size(), (int)1);
        org.testng.Assert.assertEquals((int)this.getCurrentManager().getBeans("cat").size(), (int)1);
        Bean<Cat> bean = this.getUniqueBean(Cat.class, new Cute.Literal());
        Assert.assertTypeSetMatches(bean.getTypes(), new Type[]{Object.class, Cat.class});
        Assert.assertTypeSetMatches(bean.getStereotypes(), new Type[]{PersianStereotype.class});
        org.testng.Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)bean.getQualifiers(), new Annotation[]{new Wild.Literal(true), new Cute.Literal(), Any.Literal.INSTANCE}));
        org.testng.Assert.assertEquals(ApplicationScoped.class, (Object)bean.getScope());
        org.testng.Assert.assertEquals((boolean)true, (boolean)bean.isAlternative());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="cc")})
    public void testChangesAreNotPropagated() {
        org.testng.Assert.assertTrue((boolean)this.extension.getCatAnnotatedType().getAnnotations().isEmpty());
        Assert.assertTypeSetMatches(this.extension.getCatAnnotatedType().getTypeClosure(), new Type[]{Object.class, Cat.class, Animal.class});
    }
}

