/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.se.container;

import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.se.api.ClassPath;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.tests.se.container.Foo;
import org.jboss.cdi.tck.tests.se.container.TestBuildCompatibleExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"se"})
@SpecVersion(spec="cdi", version="5.0")
public class DiscoveredAndRegisteredBceTest {
    @Deployment
    public static Archive<?> deployment() {
        JavaArchive testArchive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackage(DiscoveredAndRegisteredBceTest.class.getPackage())).addAsServiceProvider(BuildCompatibleExtension.class, new Class[]{TestBuildCompatibleExtension.class})).addAsResource((Asset)EmptyAsset.INSTANCE, "META-INF/beans.xml");
        return ClassPath.builder().add(testArchive).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="se_bootstrap", id="deb"), @SpecAssertion(section="se_container_initializer", id="b")})
    public void testAddingAlreadyDiscoveredBCE() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer seContainer = seContainerInitializer.disableDiscovery().addBeanClasses(new Class[]{Foo.class}).addBuildCompatibleExtensions(new Class[]{TestBuildCompatibleExtension.class}).initialize();){
            Instance beanInstance = seContainer.select(String.class, new Annotation[0]);
            Assert.assertTrue((boolean)beanInstance.isResolvable());
        }
    }
}

