/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.async.handlingExceptions;

import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.async.handlingExceptions.NewYorkRadioStation;
import org.jboss.cdi.tck.tests.event.observer.async.handlingExceptions.ParisRadioStation;
import org.jboss.cdi.tck.tests.event.observer.async.handlingExceptions.PragueRadioStation;
import org.jboss.cdi.tck.tests.event.observer.async.handlingExceptions.RadioMessage;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class MultipleExceptionsInObserversNotificationTest
extends AbstractTest {
    @Inject
    Event<RadioMessage> event;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(MultipleExceptionsInObserversNotificationTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="async_exception", id="a"), @SpecAssertion(section="async_exception", id="b"), @SpecAssertion(section="observer_notification", id="cb")})
    public void testMultipleExceptionsDuringVariousObserversNotification() throws InterruptedException {
        this.cleanup();
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        this.event.fireAsync((Object)new RadioMessage("ping")).handle((event, throwable) -> queue.offer(throwable));
        Throwable throwable2 = (Throwable)queue.poll(2L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)throwable2);
        Assert.assertTrue((boolean)NewYorkRadioStation.observed.get());
        Assert.assertTrue((boolean)ParisRadioStation.observed.get());
        Assert.assertTrue((boolean)PragueRadioStation.observed.get());
        Assert.assertTrue((boolean)(throwable2 instanceof CompletionException));
        List<Throwable> suppressedExceptions = Arrays.asList(throwable2.getSuppressed());
        Assert.assertTrue((suppressedExceptions.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)suppressedExceptions.contains(ParisRadioStation.exception.get()));
        Assert.assertTrue((boolean)suppressedExceptions.contains(NewYorkRadioStation.exception.get()));
        Assert.assertTrue((boolean)suppressedExceptions.stream().anyMatch(t -> t.getMessage().equals(ParisRadioStation.class.getName())));
        Assert.assertTrue((boolean)suppressedExceptions.stream().anyMatch(t -> t.getMessage().equals(NewYorkRadioStation.class.getName())));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="async_exception", id="a"), @SpecAssertion(section="async_exception", id="b"), @SpecAssertion(section="observer_notification", id="cb")})
    public void testSingleExceptionDuringVariousObserversNotification() throws InterruptedException {
        this.cleanup();
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        this.event.fireAsync((Object)new RadioMessage("pong")).handle((event, throwable) -> queue.offer(throwable));
        Throwable throwable2 = (Throwable)queue.poll(2L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)throwable2);
        Assert.assertTrue((boolean)NewYorkRadioStation.observed.get());
        Assert.assertTrue((boolean)ParisRadioStation.observed.get());
        Assert.assertTrue((boolean)PragueRadioStation.observed.get());
        Assert.assertTrue((boolean)(throwable2 instanceof CompletionException));
        List<Throwable> suppressedExceptions = Arrays.asList(throwable2.getSuppressed());
        Assert.assertTrue((suppressedExceptions.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)suppressedExceptions.contains(ParisRadioStation.exception.get()));
        Assert.assertTrue((boolean)suppressedExceptions.stream().anyMatch(t -> t.getMessage().equals(ParisRadioStation.class.getName())));
    }

    public void cleanup() {
        NewYorkRadioStation.exception = null;
        ParisRadioStation.exception = null;
        NewYorkRadioStation.observed.set(false);
        ParisRadioStation.observed.set(false);
        PragueRadioStation.observed.set(false);
    }
}

