/*
 * Decompiled with CFR 0.152.
 */
package bdvm.vm;

import java.security.MessageDigest;

public class sha1 {
    private MessageDigest sha_md;
    private byte[] sha_ctxt = new byte[352];
    private int sha_ctxt_len = 0;
    private byte[] sha_msg = new byte[320];
    private byte[] digest = new byte[20];

    public sha1() {
        try {
            this.sha_md = MessageDigest.getInstance("SHA");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void init(byte[] message, int len) throws Exception {
        this.sha_md.reset();
        for (int i = 0; i < 352; ++i) {
            this.sha_ctxt[i] = 0;
        }
        this.sha_ctxt[0] = 1;
        this.sha_ctxt[1] = 35;
        this.sha_ctxt[2] = 69;
        this.sha_ctxt[3] = 103;
        this.sha_ctxt[4] = -119;
        this.sha_ctxt[5] = -85;
        this.sha_ctxt[6] = -51;
        this.sha_ctxt[7] = -17;
        this.sha_ctxt[8] = -2;
        this.sha_ctxt[9] = -36;
        this.sha_ctxt[10] = -70;
        this.sha_ctxt[11] = -104;
        this.sha_ctxt[12] = 118;
        this.sha_ctxt[13] = 84;
        this.sha_ctxt[14] = 50;
        this.sha_ctxt[15] = 16;
        this.sha_ctxt[16] = -16;
        this.sha_ctxt[17] = -31;
        this.sha_ctxt[18] = -46;
        this.sha_ctxt[19] = -61;
        this.sha_ctxt_len = 0;
        this.sha_ctxt_len += len;
        this.sha_ctxt[340] = (byte)(this.sha_ctxt_len & 0xFF);
        this.sha_ctxt[349] = (byte)((this.sha_ctxt_len * 8 & 0xFF00) >> 8);
        this.sha_ctxt[348] = (byte)(this.sha_ctxt_len * 8 & 0xFF);
        this.sha_md.update(message);
    }

    public void update(byte[] message, int len) throws Exception {
        int i;
        for (i = 0; i < len; ++i) {
            this.sha_msg[this.sha_ctxt_len + i] = message[i];
        }
        this.sha_ctxt_len += len;
        for (i = 0; i < this.sha_ctxt_len / 4 * 4; ++i) {
            this.sha_ctxt[i + 20 ^ 3] = this.sha_msg[i];
        }
        if (this.sha_ctxt_len % 4 != 0) {
            for (i = 0; i < this.sha_ctxt_len % 4; ++i) {
                this.sha_ctxt[i + 24 - this.sha_ctxt_len % 4 + this.sha_ctxt_len / 4 * 4 ^ 3] = this.sha_msg[i + this.sha_ctxt_len / 4 * 4];
            }
        }
        this.sha_ctxt[340] = (byte)(this.sha_ctxt_len & 0xFF);
        this.sha_ctxt[349] = (byte)((this.sha_ctxt_len * 8 & 0xFF00) >> 8);
        this.sha_ctxt[348] = (byte)(this.sha_ctxt_len * 8 & 0xFF);
        this.sha_md.update(message);
    }

    public void finish(byte[] message, int len) throws Exception {
        this.sha_md.update(message);
        this.digest = this.sha_md.digest();
    }

    public void block(byte[] message) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(message);
        this.digest = md.digest();
    }

    public byte[] getHash() {
        return this.digest;
    }

    public byte[] getContext() {
        return this.sha_ctxt;
    }
}

