/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.popup;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.view.popup.PopupMenuItemContextDataDrivenNode;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContainer;

public class PopupMenuItemContextDataDriven
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 3790264690466717219L;
    private List<ExtensionPopupMenuItem> subMenus = new ArrayList<ExtensionPopupMenuItem>();

    public PopupMenuItemContextDataDriven() {
        super("DataDrivenNodeX", true);
    }

    @Override
    public String getParentMenuName() {
        return Constant.messages.getString("context.flag.popup");
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public boolean isDummyItem() {
        return true;
    }

    @Override
    public void performAction(SiteNode sn) {
    }

    @Override
    public boolean isButtonEnabledForSiteNode(SiteNode sn) {
        this.reCreateSubMenu(sn);
        return false;
    }

    protected void reCreateSubMenu(SiteNode sn) {
        Vector<JMenuItem> mainPopupMenuItems = View.getSingleton().getPopupList();
        for (ExtensionPopupMenuItem menu : this.subMenus) {
            mainPopupMenuItems.remove(menu);
        }
        this.subMenus.clear();
        Session session = Model.getSingleton().getSession();
        List<Context> contexts = session.getContexts();
        for (Context context : contexts) {
            if (!context.isIncluded(sn)) continue;
            ExtensionPopupMenuItem piicm = this.createPopupDataDrivenNodeMenu(context);
            mainPopupMenuItems.add(piicm);
            this.subMenus.add(piicm);
        }
    }

    protected ExtensionPopupMenuItem createPopupDataDrivenNodeMenu(Context context) {
        return new PopupMenuItemContextDataDrivenNode(context, Constant.messages.getString("context.flag.popup.datadriven", context.getName()));
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

