/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.io;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class BufferPool {
    private static final Log log = LogFactory.getLog(BufferPool.class);
    public static final int DEFAULT_POOL_SIZE = Integer.getInteger("org.apache.catalina.tribes.io.BufferPool.DEFAULT_POOL_SIZE", 0x6400000);
    protected static final StringManager sm = StringManager.getManager(BufferPool.class);
    protected static volatile BufferPool instance = null;
    protected int maxSize;
    protected final AtomicInteger size = new AtomicInteger(0);
    protected final ConcurrentLinkedQueue<XByteBuffer> queue = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BufferPool getBufferPool() {
        if (instance != null) return instance;
        Class<BufferPool> clazz = BufferPool.class;
        synchronized (BufferPool.class) {
            if (instance != null) return instance;
            BufferPool bufferPool = new BufferPool();
            bufferPool.setMaxSize(DEFAULT_POOL_SIZE);
            log.info((Object)sm.getString("bufferPool.created", Integer.toString(DEFAULT_POOL_SIZE), bufferPool.getClass().getName()));
            instance = bufferPool;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private BufferPool() {
    }

    public XByteBuffer getBuffer(int n, boolean bl) {
        XByteBuffer xByteBuffer = this.queue.poll();
        if (xByteBuffer != null) {
            this.size.addAndGet(-xByteBuffer.getCapacity());
        }
        if (xByteBuffer == null) {
            xByteBuffer = new XByteBuffer(n, bl);
        } else if (xByteBuffer.getCapacity() <= n) {
            xByteBuffer.expand(n);
        }
        xByteBuffer.setDiscard(bl);
        xByteBuffer.reset();
        return xByteBuffer;
    }

    public void returnBuffer(XByteBuffer xByteBuffer) {
        if (this.size.get() + xByteBuffer.getCapacity() <= this.maxSize) {
            this.size.addAndGet(xByteBuffer.getCapacity());
            this.queue.offer(xByteBuffer);
        }
    }

    public void clear() {
        this.queue.clear();
        this.size.set(0);
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

