/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncPushProducer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.config.H2Param;
import org.apache.hc.core5.http2.config.H2Setting;
import org.apache.hc.core5.http2.frame.DefaultFrameFactory;
import org.apache.hc.core5.http2.frame.FrameFactory;
import org.apache.hc.core5.http2.frame.StreamIdGenerator;
import org.apache.hc.core5.http2.impl.nio.AbstractH2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.ClientH2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.ClientPushH2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.H2Stream;
import org.apache.hc.core5.http2.impl.nio.H2StreamChannel;
import org.apache.hc.core5.http2.impl.nio.H2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.H2StreamListener;
import org.apache.hc.core5.reactor.ProtocolIOSession;

@Internal
public class ClientH2StreamMultiplexer
extends AbstractH2StreamMultiplexer {
    private final HandlerFactory<AsyncPushConsumer> pushHandlerFactory;

    public ClientH2StreamMultiplexer(ProtocolIOSession ioSession, FrameFactory frameFactory, HttpProcessor httpProcessor, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, H2Config h2Config, CharCodingConfig charCodingConfig, H2StreamListener streamListener) {
        super(ioSession, frameFactory, StreamIdGenerator.ODD, httpProcessor, charCodingConfig, h2Config, streamListener);
        this.pushHandlerFactory = pushHandlerFactory;
    }

    public ClientH2StreamMultiplexer(ProtocolIOSession ioSession, HttpProcessor httpProcessor, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, H2Config h2Config, CharCodingConfig charCodingConfig) {
        this(ioSession, DefaultFrameFactory.INSTANCE, httpProcessor, pushHandlerFactory, h2Config, charCodingConfig, null);
    }

    public ClientH2StreamMultiplexer(ProtocolIOSession ioSession, HttpProcessor httpProcessor, H2Config h2Config, CharCodingConfig charCodingConfig) {
        this(ioSession, httpProcessor, null, h2Config, charCodingConfig);
    }

    @Override
    void validateSetting(H2Param param, int value) throws H2ConnectionException {
        if (param == H2Param.ENABLE_PUSH && value == 1) {
            throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal ENABLE_PUSH setting");
        }
    }

    @Override
    H2Setting[] generateSettings(H2Config localConfig) {
        return new H2Setting[]{new H2Setting(H2Param.HEADER_TABLE_SIZE, localConfig.getHeaderTableSize()), new H2Setting(H2Param.ENABLE_PUSH, localConfig.isPushEnabled() ? 1 : 0), new H2Setting(H2Param.MAX_CONCURRENT_STREAMS, localConfig.getMaxConcurrentStreams()), new H2Setting(H2Param.INITIAL_WINDOW_SIZE, localConfig.getInitialWindowSize()), new H2Setting(H2Param.MAX_FRAME_SIZE, localConfig.getMaxFrameSize()), new H2Setting(H2Param.MAX_HEADER_LIST_SIZE, localConfig.getMaxHeaderListSize()), new H2Setting(H2Param.SETTINGS_NO_RFC7540_PRIORITIES, 1)};
    }

    @Override
    void acceptHeaderFrame() throws H2ConnectionException {
        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal HEADERS frame");
    }

    @Override
    void acceptPushFrame() {
    }

    @Override
    void acceptPushRequest() throws H2ConnectionException {
        throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Illegal attempt to push a response");
    }

    @Override
    H2StreamHandler outgoingRequest(H2StreamChannel channel, AsyncClientExchangeHandler exchangeHandler, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpContext context) {
        HttpCoreContext coreContext = HttpCoreContext.castOrCreate((HttpContext)context);
        coreContext.setSSLSession(this.getSSLSession());
        coreContext.setEndpointDetails(this.getEndpointDetails());
        return new ClientH2StreamHandler(channel, this.getHttpProcessor(), this.getConnMetrics(), exchangeHandler, pushHandlerFactory != null ? pushHandlerFactory : this.pushHandlerFactory, coreContext);
    }

    @Override
    H2StreamHandler incomingRequest(H2StreamChannel channel) throws IOException {
        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal incoming request");
    }

    @Override
    H2StreamHandler outgoingPushPromise(H2StreamChannel channel, AsyncPushProducer pushProducer) throws IOException {
        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal attempt to send push promise");
    }

    @Override
    H2StreamHandler incomingPushPromise(H2StreamChannel channel, HandlerFactory<AsyncPushConsumer> pushHandlerFactory) {
        HttpCoreContext context = HttpCoreContext.create();
        context.setSSLSession(this.getSSLSession());
        context.setEndpointDetails(this.getEndpointDetails());
        return new ClientPushH2StreamHandler(channel, this.getHttpProcessor(), this.getConnMetrics(), pushHandlerFactory != null ? pushHandlerFactory : this.pushHandlerFactory, context);
    }

    @Override
    boolean allowGracefulAbort(H2Stream stream) {
        return stream.isRemoteClosed() && !stream.isLocalClosed();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        this.appendState(buf);
        buf.append("]");
        return buf.toString();
    }
}

