/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.FeatureData;
import org.opensearch.timeseries.model.IndexableResult;

public abstract class ResultResponse<IndexableResultType extends IndexableResult>
extends ActionResponse
implements ToXContentObject {
    protected String error;
    protected List<FeatureData> features;
    protected Long rcfTotalUpdates;
    protected Long configIntervalInMinutes;
    protected Boolean isHC;
    protected String taskId;

    public ResultResponse(List<FeatureData> features, String error, Long rcfTotalUpdates, Long configInterval, Boolean isHC, String taskId) {
        this.error = error;
        this.features = features;
        this.rcfTotalUpdates = rcfTotalUpdates;
        this.configIntervalInMinutes = configInterval;
        this.isHC = isHC;
        this.taskId = taskId;
    }

    public ResultResponse(StreamInput in) throws IOException {
        super(in);
    }

    public String getError() {
        return this.error;
    }

    public List<FeatureData> getFeatures() {
        return this.features;
    }

    public Long getRcfTotalUpdates() {
        return this.rcfTotalUpdates;
    }

    public Long getConfigIntervalInMinutes() {
        return this.configIntervalInMinutes;
    }

    public Boolean isHC() {
        return this.isHC;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public boolean shouldSave() {
        return this.error != null;
    }

    public abstract List<IndexableResultType> toIndexableResults(Config var1, Instant var2, Instant var3, Instant var4, Instant var5, Integer var6, User var7, String var8);
}

