/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class Image3D extends Resource {

	public Image3D(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * returns the name of this Image3D
	 *
	 * @return the name of this Image3D
	 * @throws Lib3MFException
	 */
	public String getName() throws Lib3MFException {
		Pointer bytesNeededName = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_image3d_getname.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededName, null}));
		int sizeName = bytesNeededName.getInt(0);
		Pointer bufferName = new Memory(sizeName);
		mWrapper.checkError(this, mWrapper.lib3mf_image3d_getname.invokeInt(new java.lang.Object[]{mHandle, sizeName, bytesNeededName, bufferName}));
		return new String(bufferName.getByteArray(0, sizeName - 1), StandardCharsets.UTF_8);
	}

	/**
	 * sets a new name of this Image3D
	 *
	 * @param name the new name of this Image3D
	 * @throws Lib3MFException
	 */
	public void setName(String name) throws Lib3MFException {
		byte[] bytesName = name.getBytes(StandardCharsets.UTF_8);
		Memory bufferName = new Memory(bytesName.length + 1);
		bufferName.write(0, bytesName, 0, bytesName.length);
		bufferName.setByte(bytesName.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_image3d_setname.invokeInt(new java.lang.Object[]{mHandle, bufferName}));
	}

	/**
	 * Retrieves, if this Image3D is a ImageStack
	 *
	 * @return returns, whether the Image3D is an ImageStack
	 * @throws Lib3MFException
	 */
	public boolean isImageStack() throws Lib3MFException {
		Pointer bufferIsImageStack = new Memory(1);
		mWrapper.checkError(this, mWrapper.lib3mf_image3d_isimagestack.invokeInt(new java.lang.Object[]{mHandle, bufferIsImageStack}));
		return bufferIsImageStack.getByte(0) != 0;
	}


}

