/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class VolumeDataComposite extends Base {

	public VolumeDataComposite(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Returns the BaseMaterialGroup used within this volume data item
	 *
	 * @return The BaseMaterialGroup instance of this VolumeDataComposite element
	 * @throws Lib3MFException
	 */
	public BaseMaterialGroup getBaseMaterialGroup() throws Lib3MFException {
		Pointer bufferBaseMaterialGroupInstance = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_volumedatacomposite_getbasematerialgroup.invokeInt(new java.lang.Object[]{mHandle, bufferBaseMaterialGroupInstance}));
		Pointer valueBaseMaterialGroupInstance = bufferBaseMaterialGroupInstance.getPointer(0);
		BaseMaterialGroup baseMaterialGroupInstance = null;
		if (valueBaseMaterialGroupInstance == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "BaseMaterialGroupInstance was a null pointer");
		}
		baseMaterialGroupInstance = mWrapper.PolymorphicFactory(valueBaseMaterialGroupInstance, BaseMaterialGroup.class);
		return baseMaterialGroupInstance;
	}

	/**
	 * Sets the BaseMaterialGroup to use within this volume data item.
	 *
	 * @param baseMaterialGroupInstance The new BaseMaterialGroup instance of this VolumeDataComposite element
	 * @throws Lib3MFException
	 */
	public void setBaseMaterialGroup(BaseMaterialGroup baseMaterialGroupInstance) throws Lib3MFException {
		Pointer baseMaterialGroupInstanceHandle = null;
		if (baseMaterialGroupInstance != null) {
			baseMaterialGroupInstanceHandle = baseMaterialGroupInstance.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "BaseMaterialGroupInstance is a null value.");
		}
		mWrapper.checkError(this, mWrapper.lib3mf_volumedatacomposite_setbasematerialgroup.invokeInt(new java.lang.Object[]{mHandle, baseMaterialGroupInstanceHandle}));
	}

	/**
	 * Returns the number of material mappings of this VolumeDataComposite element
	 *
	 * @return the number of material mappings.
	 * @throws Lib3MFException
	 */
	public int getMaterialMappingCount() throws Lib3MFException {
		Pointer bufferCount = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_volumedatacomposite_getmaterialmappingcount.invokeInt(new java.lang.Object[]{mHandle, bufferCount}));
		return bufferCount.getInt(0);
	}

	/**
	 * Returns MaterialMapping with given index
	 *
	 * @param index Index of the MaterialMapping in question.
	 * @return MaterialMapping used in this element
	 * @throws Lib3MFException
	 */
	public MaterialMapping getMaterialMapping(int index) throws Lib3MFException {
		Pointer bufferTheMaterialMapping = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_volumedatacomposite_getmaterialmapping.invokeInt(new java.lang.Object[]{mHandle, index, bufferTheMaterialMapping}));
		Pointer valueTheMaterialMapping = bufferTheMaterialMapping.getPointer(0);
		MaterialMapping theMaterialMapping = null;
		if (valueTheMaterialMapping == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "TheMaterialMapping was a null pointer");
		}
		theMaterialMapping = mWrapper.PolymorphicFactory(valueTheMaterialMapping, MaterialMapping.class);
		return theMaterialMapping;
	}

	/**
	 * Adds a MaterialMapping
	 *
	 * @param transform new transformation matrix
	 * @return The new MaterialMapping
	 * @throws Lib3MFException
	 */
	public MaterialMapping addMaterialMapping(Transform transform) throws Lib3MFException {
		Pointer bufferTransform = new Memory(Transform.SIZE);
		transform.writeToPointer(bufferTransform, 0);
		Pointer bufferTheMaterialMapping = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_volumedatacomposite_addmaterialmapping.invokeInt(new java.lang.Object[]{mHandle, bufferTransform, bufferTheMaterialMapping}));
		Pointer valueTheMaterialMapping = bufferTheMaterialMapping.getPointer(0);
		MaterialMapping theMaterialMapping = null;
		if (valueTheMaterialMapping == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "TheMaterialMapping was a null pointer");
		}
		theMaterialMapping = mWrapper.PolymorphicFactory(valueTheMaterialMapping, MaterialMapping.class);
		return theMaterialMapping;
	}

	/**
	 * Removes the MaterialMapping with given index
	 *
	 * @param index The index of the MaterialMapping to be removed.
	 * @throws Lib3MFException
	 */
	public void removeMaterialMapping(int index) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_volumedatacomposite_removematerialmapping.invokeInt(new java.lang.Object[]{mHandle, index}));
	}


}

